/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class UserFunction
extends Procedure
implements InstructionInfoProvider {
    private int functionNameCode;
    private boolean memoFunction = false;
    private boolean tailRecursive = false;
    private UserFunctionParameter[] parameterDefinitions;
    private SequenceType resultType;
    private int evaluationMode = -1;
    private transient InstructionDetails details = null;

    public UserFunction() {
    }

    public UserFunction(Expression expression) {
        this.setBody(expression);
    }

    public void computeEvaluationMode() {
        this.evaluationMode = this.tailRecursive || this.memoFunction ? ExpressionTool.eagerEvaluationMode(this.getBody()) : ExpressionTool.lazyEvaluationMode(this.getBody());
    }

    public void setParameterDefinitions(UserFunctionParameter[] userFunctionParameterArray) {
        this.parameterDefinitions = userFunctionParameterArray;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setResultType(SequenceType sequenceType) {
        this.resultType = sequenceType;
    }

    public void setTailRecursive(boolean bl) {
        this.tailRecursive = bl;
    }

    public boolean isTailRecursive() {
        return this.tailRecursive;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public SequenceType getArgumentType(int n) {
        return this.parameterDefinitions[n].getRequiredType();
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        return this.evaluationMode;
    }

    public int getNumberOfArguments() {
        return this.parameterDefinitions.length;
    }

    public void setMemoFunction(boolean bl) {
        this.memoFunction = bl;
    }

    public void setFunctionNameCode(int n) {
        this.functionNameCode = n;
    }

    public int getFunctionNameCode() {
        return this.functionNameCode;
    }

    public ValueRepresentation call(ValueRepresentation[] valueRepresentationArray, XPathContextMajor xPathContextMajor) throws XPathException {
        ValueRepresentation valueRepresentation;
        Controller controller = xPathContextMajor.getController();
        if (this.memoFunction && (valueRepresentation = this.getCachedValue(controller, valueRepresentationArray)) != null) {
            return valueRepresentation;
        }
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        xPathContextMajor.setStackFrame(this.getStackFrameMap(), valueRepresentationArray);
        try {
            valueRepresentation = ExpressionTool.evaluate(this.getBody(), this.evaluationMode, xPathContextMajor, 1);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
        if (this.memoFunction) {
            this.putCachedValue(controller, valueRepresentationArray, valueRepresentation);
        }
        return valueRepresentation;
    }

    public void process(ValueRepresentation[] valueRepresentationArray, XPathContextMajor xPathContextMajor) throws XPathException {
        xPathContextMajor.setStackFrame(this.getStackFrameMap(), valueRepresentationArray);
        this.getBody().process(xPathContextMajor);
    }

    public ValueRepresentation call(ValueRepresentation[] valueRepresentationArray, Controller controller) throws XPathException {
        return this.call(valueRepresentationArray, controller.newXPathContext());
    }

    private ValueRepresentation getCachedValue(Controller controller, ValueRepresentation[] valueRepresentationArray) throws XPathException {
        HashMap hashMap = (HashMap)controller.getUserData(this, "memo-function-cache");
        if (hashMap == null) {
            return null;
        }
        String string = UserFunction.getCombinedKey(valueRepresentationArray);
        return (ValueRepresentation)hashMap.get(string);
    }

    private void putCachedValue(Controller controller, ValueRepresentation[] valueRepresentationArray, ValueRepresentation valueRepresentation) throws XPathException {
        HashMap<String, ValueRepresentation> hashMap = (HashMap<String, ValueRepresentation>)controller.getUserData(this, "memo-function-cache");
        if (hashMap == null) {
            hashMap = new HashMap<String, ValueRepresentation>(32);
            controller.setUserData(this, "memo-function-cache", hashMap);
        }
        String string = UserFunction.getCombinedKey(valueRepresentationArray);
        hashMap.put(string, valueRepresentation);
    }

    private static String getCombinedKey(ValueRepresentation[] valueRepresentationArray) throws XPathException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(120);
        for (int i = 0; i < valueRepresentationArray.length; ++i) {
            Item item;
            ValueRepresentation valueRepresentation = valueRepresentationArray[i];
            SequenceIterator sequenceIterator = Value.getIterator(valueRepresentation);
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof NodeInfo) {
                    NodeInfo nodeInfo = (NodeInfo)item;
                    nodeInfo.generateId(fastStringBuffer);
                } else {
                    fastStringBuffer.append("" + Type.displayTypeName(item));
                    fastStringBuffer.append('/');
                    fastStringBuffer.append(item.getStringValueCS());
                }
                fastStringBuffer.append('\u0001');
            }
            fastStringBuffer.append('\u0002');
        }
        return fastStringBuffer.toString();
    }

    public InstructionInfo getInstructionInfo() {
        if (this.details == null) {
            this.details = new InstructionDetails();
            this.details.setSystemId(this.getSystemId());
            this.details.setLineNumber(this.getLineNumber());
            this.details.setConstructType(149);
            this.details.setObjectNameCode(this.functionNameCode);
            this.details.setProperty("function", this);
        }
        return this.details;
    }
}

