/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.dom4j.ElementFactory;
import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.QNameCache;

class NameCache
extends QNameCache {
    ElementFactory factory;

    public NameCache() {
    }

    public NameCache(ElementFactory factory) {
        super((DocumentFactory)factory);
        this.factory = factory;
    }

    public QName get(String name) {
        QName answer = (QName)this.noNamespaceCache.get(name);
        if (answer == null) {
            answer = NameImpl.create(name);
            answer.setDocumentFactory((DocumentFactory)this.factory);
            this.noNamespaceCache.put(name, answer);
        }
        return answer;
    }

    public QName get(String name, Namespace namespace) {
        Map cache = this.getNamespaceCache(namespace);
        QName answer = (QName)cache.get(name);
        if (answer == null) {
            answer = NameImpl.create(name, namespace);
            answer.setDocumentFactory((DocumentFactory)this.factory);
            cache.put(name, answer);
        }
        return answer;
    }

    public QName get(String localName, Namespace namespace, String qualifiedName) {
        Map cache = this.getNamespaceCache(namespace);
        QName answer = (QName)cache.get(localName);
        if (answer == null) {
            answer = NameImpl.create(localName, namespace, qualifiedName);
            answer.setDocumentFactory((DocumentFactory)this.factory);
            cache.put(localName, answer);
        }
        return answer;
    }

    public QName get(String qualifiedName, String uri) {
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            return this.get(qualifiedName, Namespace.get((String)uri));
        }
        String name = qualifiedName.substring(index + 1);
        String prefix = qualifiedName.substring(0, index);
        return this.get(name, Namespace.get((String)prefix, (String)uri));
    }
}

