/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMAttributeMap
implements NamedNodeMap {
    private NodeInfo parent;
    private int numberOfNamespaces = -1;

    public DOMAttributeMap(NodeInfo nodeInfo) {
        this.parent = nodeInfo;
    }

    public Node getNamedItem(String string) {
        NodeInfo nodeInfo;
        if (string.equals("xmlns")) {
            int[] nArray = this.parent.getDeclaredNamespaces(null);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) {
                    return null;
                }
                if ((nArray[i] >> 16 & 0xFFFF) != 0) continue;
                NamespaceIterator.NamespaceNodeImpl namespaceNodeImpl = new NamespaceIterator.NamespaceNodeImpl(this.parent, nArray[i], i + 1);
                return NodeOverNodeInfo.wrap((NodeInfo)namespaceNodeImpl);
            }
            return null;
        }
        if (string.startsWith("xmlns:")) {
            String string2 = string.substring(6);
            if (string2.equals("xml")) {
                NamespaceIterator.NamespaceNodeImpl namespaceNodeImpl = new NamespaceIterator.NamespaceNodeImpl(this.parent, 1, 0);
                return NodeOverNodeInfo.wrap((NodeInfo)namespaceNodeImpl);
            }
            int[] nArray = new int[8];
            int[] nArray2 = this.parent.getDeclaredNamespaces(nArray);
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == -1) {
                    return null;
                }
                if (!string2.equals(this.parent.getNamePool().getPrefixFromNamespaceCode(nArray2[i]))) continue;
                NamespaceIterator.NamespaceNodeImpl namespaceNodeImpl = new NamespaceIterator.NamespaceNodeImpl(this.parent, nArray2[i], i + 1);
                return NodeOverNodeInfo.wrap((NodeInfo)namespaceNodeImpl);
            }
            return null;
        }
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return null;
        } while (!string.equals(nodeInfo.getDisplayName()));
        return NodeOverNodeInfo.wrap(nodeInfo);
    }

    public Node item(int n) {
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            NamespaceIterator.NamespaceNodeImpl namespaceNodeImpl = new NamespaceIterator.NamespaceNodeImpl(this.parent, 65537, 0);
            return NodeOverNodeInfo.wrap((NodeInfo)namespaceNodeImpl);
        }
        int n2 = this.getNumberOfNamespaces();
        if (n < n2) {
            int[] nArray = new int[8];
            int[] nArray2 = this.parent.getDeclaredNamespaces(nArray);
            int n3 = nArray2[n - 1];
            NamespaceIterator.NamespaceNodeImpl namespaceNodeImpl = new NamespaceIterator.NamespaceNodeImpl(this.parent, n3, n);
            return NodeOverNodeInfo.wrap((NodeInfo)namespaceNodeImpl);
        }
        int n4 = 0;
        int n5 = n - n2;
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (n4 == n5) {
                return NodeOverNodeInfo.wrap(nodeInfo);
            }
            ++n4;
        }
        return null;
    }

    private int getNumberOfNamespaces() {
        if (this.numberOfNamespaces == -1) {
            int[] nArray = new int[8];
            int[] nArray2 = this.parent.getDeclaredNamespaces(nArray);
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] != -1) continue;
                n = i - 1;
                break;
            }
            this.numberOfNamespaces = n + 1;
        }
        return this.numberOfNamespaces;
    }

    public int getLength() {
        int n = 0;
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        while (axisIterator.next() != null) {
            ++n;
        }
        return this.getNumberOfNamespaces() + n;
    }

    public Node getNamedItemNS(String string, String string2) {
        NodeInfo nodeInfo;
        if (string == null) {
            string = "";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return this.getNamedItem("xmlns:" + string2);
        }
        if (string.equals("") && string2.equals("xmlns")) {
            return this.getNamedItem("xmlns");
        }
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return null;
        } while (!string.equals(nodeInfo.getURI()) || !string2.equals(nodeInfo.getLocalPart()));
        return NodeOverNodeInfo.wrap(nodeInfo);
    }

    public Node setNamedItem(Node node) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }
}

