/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.SignerOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.w3c.dom.Element;

public final class DOMRSASignatureMethod
extends DOMSignatureMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private Signature signature;

    public DOMRSASignatureMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#rsa-sha1", params);
    }

    public DOMRSASignatureMethod(Element smElem) throws MarshalException {
        super(smElem);
    }

    protected void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for RSA signature algorithm");
        }
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA signature algorithm");
    }

    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA signature algorithm");
    }

    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    public boolean verify(Key key, DOMSignedInfo si, byte[] sig, XMLValidateContext context) throws InvalidKeyException, SignatureException, XMLSignatureException {
        if (key == null || si == null || sig == null) {
            throw new NullPointerException("key, signed info or signature cannot be null");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SignatureException("SHA1withRSA Signature not found");
            }
        }
        this.signature.initVerify((PublicKey)key);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signature provider:" + this.signature.getProvider());
            log.log(Level.FINE, "verifying with key: " + key);
        }
        si.canonicalize(context, new SignerOutputStream(this.signature));
        return this.signature.verify(sig);
    }

    public byte[] sign(Key key, DOMSignedInfo si, XMLSignContext context) throws InvalidKeyException, XMLSignatureException {
        if (key == null || si == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("SHA1withRSA Signature not found");
            }
        }
        this.signature.initSign((PrivateKey)key);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signature provider:" + this.signature.getProvider());
            log.log(Level.FINE, "Signing with key: " + key);
        }
        si.canonicalize(context, new SignerOutputStream(this.signature));
        try {
            return this.signature.sign();
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
    }
}

