/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.keyinfo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public abstract class KeyInfoFactory {
    private String mechanismType;
    private Provider provider;
    private static Class cl;
    private static final Class[] getImplParams;
    private static Method getImplMethod;

    static {
        getImplParams = new Class[]{String.class, String.class, Provider.class};
        try {
            cl = Class.forName("javax.xml.crypto.dsig.XMLDSigSecurity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        getImplMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method m = null;
                try {
                    m = cl.getDeclaredMethod("getImpl", getImplParams);
                    if (m != null) {
                        m.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return m;
            }
        });
    }

    protected KeyInfoFactory() {
    }

    public static KeyInfoFactory getInstance(String mechanismType) {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        return KeyInfoFactory.findInstance(mechanismType, null);
    }

    private static KeyInfoFactory findInstance(String mechanismType, Provider provider) {
        if (getImplMethod == null) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type");
        }
        Object[] objs = null;
        try {
            objs = (Object[])getImplMethod.invoke(null, mechanismType, "KeyInfoFactory", provider);
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type", iae);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type", ite);
        }
        KeyInfoFactory factory = (KeyInfoFactory)objs[0];
        factory.mechanismType = mechanismType;
        factory.provider = (Provider)objs[1];
        return factory;
    }

    public static KeyInfoFactory getInstance(String mechanismType, Provider provider) {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        return KeyInfoFactory.findInstance(mechanismType, provider);
    }

    public static KeyInfoFactory getInstance(String mechanismType, String provider) throws NoSuchProviderException {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("cannot find provider named " + provider);
        }
        return KeyInfoFactory.findInstance(mechanismType, prov);
    }

    public static KeyInfoFactory getInstance() {
        return KeyInfoFactory.getInstance("DOM");
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract KeyInfo newKeyInfo(List var1);

    public abstract KeyInfo newKeyInfo(List var1, String var2);

    public abstract KeyName newKeyName(String var1);

    public abstract KeyValue newKeyValue(PublicKey var1) throws KeyException;

    public abstract PGPData newPGPData(byte[] var1);

    public abstract PGPData newPGPData(byte[] var1, byte[] var2, List var3);

    public abstract PGPData newPGPData(byte[] var1, List var2);

    public abstract RetrievalMethod newRetrievalMethod(String var1);

    public abstract RetrievalMethod newRetrievalMethod(String var1, String var2, List var3);

    public abstract X509Data newX509Data(List var1);

    public abstract X509IssuerSerial newX509IssuerSerial(String var1, BigInteger var2);

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    public abstract KeyInfo unmarshalKeyInfo(XMLStructure var1) throws MarshalException;
}

