/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.FilterIterator;

public class ElementImpl
extends DefaultElement
implements SOAPElement {
    static final String cdataUC = "<![CDATA[";
    static final String cdataLC = "<![cdata[";
    Name encodingStyleAttName = NameImpl.create("encodingStyle", NameImpl.soapNamespace);

    public ElementImpl(String name) {
        super(name);
    }

    public ElementImpl(NameImpl qname) {
        super((QName)qname);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        NameImpl n = (NameImpl)name;
        return (SOAPElement)this.addElement(n);
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addChildElement(NameImpl.create(localName));
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        Namespace ns = this.getNamespaceForPrefix(prefix);
        if (ns == null) {
            throw new SOAPException("Unable to locate namespace for prefix " + prefix);
        }
        return this.addChildElement(NameImpl.create(localName, ns));
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        if (element.getElementName().getURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            throw new SOAPException("Can not add fragments which contain elements which are in the SOAP namespace");
        }
        SOAPElement copy = this.addChildElement(element.getElementName());
        try {
            String encoding = element.getEncodingStyle();
            if (encoding != null) {
                copy.setEncodingStyle(encoding);
            }
            Iterator it = element.getNamespacePrefixes();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                copy.addNamespaceDeclaration(prefix, element.getNamespaceURI(prefix));
            }
            it = element.getAllAttributes();
            while (it.hasNext()) {
                Name name = (Name)it.next();
                copy.addAttribute(name, element.getAttributeValue(name));
            }
            it = element.getChildElements();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (n instanceof Text) {
                    copy.addTextNode(n.getValue());
                    continue;
                }
                if (n instanceof SOAPElement) {
                    copy.addChildElement((SOAPElement)n);
                    continue;
                }
                throw new SOAPException("Invalid element type: " + element.getElementName().getQualifiedName());
            }
        }
        catch (SOAPException ex) {
            copy.detachNode();
            throw ex;
        }
        return copy;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        return this.addChildElement(NameImpl.create(localName, Namespace.get((String)prefix, (String)uri)));
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        if (text.startsWith(cdataUC) || text.startsWith(cdataLC)) {
            return (SOAPElement)this.addCDATA(text);
        }
        return (SOAPElement)this.addText(text);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        this.addAttribute((QName)name, value);
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        this.addNamespace(prefix, uri);
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributeValue((QName)name);
    }

    public Iterator getAllAttributes() {
        return new Iterator(){
            Iterator orig;
            {
                this.orig = ElementImpl.this.attributes().listIterator();
            }

            public boolean hasNext() {
                return this.orig.hasNext();
            }

            public Object next() {
                Attribute attrib = (Attribute)this.orig.next();
                return attrib.getQName();
            }

            public void remove() {
                this.orig.remove();
            }
        };
    }

    public String getNamespaceURI(String prefix) {
        Namespace ns = this.getNamespaceForPrefix(prefix);
        if (ns != null) {
            return ns.getURI();
        }
        return null;
    }

    public Iterator getNamespacePrefixes() {
        return new Iterator(){
            Iterator namespaces;
            {
                this.namespaces = ElementImpl.this.additionalNamespaces().listIterator();
            }

            public boolean hasNext() {
                return this.namespaces.hasNext();
            }

            public Object next() {
                Namespace ns = (Namespace)this.namespaces.next();
                return ns.getPrefix();
            }

            public void remove() {
                this.namespaces.remove();
            }
        };
    }

    public Name getElementName() {
        return (Name)this.getQName();
    }

    public boolean removeAttribute(Name name) {
        Attribute attrib = this.attribute((QName)name);
        if (attrib != null) {
            return this.remove(attrib);
        }
        return false;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        Namespace ns = this.getNamespaceForPrefix(prefix);
        if (ns != null) {
            return this.remove(ns);
        }
        return false;
    }

    public Iterator getChildElements() {
        return new FilterIterator(this.nodeIterator()){

            protected boolean matches(Object element) {
                return element instanceof SOAPElement || element instanceof Text;
            }
        };
    }

    public Iterator getChildElements(Name name) {
        return this.elementIterator((QName)name);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        try {
            JaxmURI uri = new JaxmURI(encodingStyle);
        }
        catch (JaxmURI.MalformedURIException m) {
            throw new IllegalArgumentException("Encoding style (" + encodingStyle + ") should be a valid URI");
        }
        this.removeAttribute(this.encodingStyleAttName);
        this.addAttribute(this.encodingStyleAttName, encodingStyle);
    }

    public String getEncodingStyle() {
        return this.getAttributeValue(this.encodingStyleAttName);
    }

    public String getValue() {
        return this.getText();
    }

    public void setParentElement(SOAPElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Null argument to setParentElement");
        }
        this.setParent((Element)element);
    }

    public SOAPElement getParentElement() {
        return (SOAPElement)this.getParent();
    }

    public void detachNode() {
        super.detach();
    }

    public void recycleNode() {
        this.detachNode();
    }
}

