/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.generator;

import com.softmeca.util.io.FileIoUtil;
import com.softmeca.util.log.LogUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.kldp.ebmsh.bi.generator.context.ActionHandlerProcesserContext;
import org.kldp.ebmsh.bi.generator.context.Ejb2EjbJarContext;
import org.kldp.ebmsh.bi.generator.context.Ejb2MDBContext;
import org.kldp.ebmsh.bi.generator.context.Jeus5ServerDescriptionContext;
import org.kldp.ebmsh.bi.generator.source.ActionHandlerProcesserGenerator;
import org.kldp.ebmsh.bi.generator.source.Ejb2EjbJarGenerator;
import org.kldp.ebmsh.bi.generator.source.Ejb2MDBSourceGenerator;
import org.kldp.ebmsh.bi.generator.source.EjbJarGenerator;
import org.kldp.ebmsh.bi.generator.source.Jeus5ServerDescriptionGenerator;
import org.kldp.ebmsh.bi.generator.source.MDBSourceGenerator;
import org.kldp.ebmsh.bi.generator.source.ServerDescriptionGenerator;
import org.kldp.ebmsh.bi.generator.template.VelocityTemplateEngine;

public class Generator {
    public static void Error(String errorMessage) {
        System.out.println();
        System.out.println("----- Error -----");
        System.out.println(errorMessage);
        System.out.println("----- Error -----");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] args) {
        try {
            StringBuffer errorMessage;
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Ejb \ubc84\uc804 [\uac00\ub2a5\ud55c \ubc84\uc804: 2.0] : ");
            String ejbVersion = stdin.readLine();
            System.out.print("\uc11c\ubc84 \ud0c0\uc785 [\uac00\ub2a5\ud55c \uc11c\ubc84: jeus5.0] : ");
            String serverType = stdin.readLine();
            System.out.print("\uc11c\ubc84\uc758 QueueConnectionFactory \uc774\ub984 [Jeus \uae30\ubcf8 QueueConnectionFactory: queueConnectionFactory] : ");
            String queueConnectionFactoryName = stdin.readLine();
            System.out.print("\uc0dd\uc131\ud560 Action \uc774\ub984 : ");
            String actionName = stdin.readLine();
            String outputDirectory = String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)"output")) + actionName;
            stdin.close();
            System.out.println();
            System.out.println("----- \uc785\ub825\ud55c \uac12 -----");
            System.out.println("Ejb \ubc84\uc804 : " + ejbVersion);
            System.out.println("\uc11c\ubc84 \ud0c0\uc785 : " + serverType);
            System.out.println("\uc11c\ubc84\uc758 QueueConnectionFactory \uc774\ub984 : " + queueConnectionFactoryName);
            System.out.println("\uc0dd\uc131\ud560 Action \uc774\ub984 : " + actionName);
            System.out.println("----- \uc785\ub825\ud55c \uac12 -----");
            System.out.println();
            VelocityTemplateEngine templateEngine = null;
            Ejb2EjbJarGenerator ejbJarGenerator = null;
            Ejb2MDBSourceGenerator mdbGenerator = null;
            Jeus5ServerDescriptionGenerator serverDescriptionGenerator = null;
            ActionHandlerProcesserGenerator actionHandlerProcesserGenerator = null;
            Ejb2EjbJarContext ejbJarContext = null;
            Ejb2MDBContext mdbContext = null;
            Jeus5ServerDescriptionContext serverDescriptionContext = null;
            ActionHandlerProcesserContext actionHandlerProcesserContext = null;
            System.out.println("----- \ucd08\uae30\ud654 -----");
            System.out.println("Template \uc5d4\uc9c4\uc744 \ucd08\uae30\ud654 \ud569\ub2c8\ub2e4.");
            templateEngine = new VelocityTemplateEngine();
            System.out.println("EjbJarGenerator\ub97c \ucd08\uae30\ud654 \ud569\ub2c8\ub2e4.");
            if (ejbVersion.equals("2.0")) {
                ejbJarGenerator = new Ejb2EjbJarGenerator(templateEngine);
                Ejb2EjbJarContext ejb2EjbJarContext = new Ejb2EjbJarContext();
                ejb2EjbJarContext.setClassName(actionName);
                ejb2EjbJarContext.setEjbName(actionName);
                ejbJarContext = ejb2EjbJarContext;
            } else {
                errorMessage = new StringBuffer();
                errorMessage.append("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 ejb version \uc785\ub2c8\ub2e4.\n");
                errorMessage.append("\uc785\ub825\ud55c \ubc84\uc804 : " + ejbVersion + " \uac00\ub2a5\ud55c \ubc84\uc804 : 2.0");
                Generator.Error(errorMessage.toString());
            }
            System.out.println("MDBSourceGenerator\ub97c \ucd08\uae30\ud654 \ud569\ub2c8\ub2e4.");
            if (ejbVersion.equals("2.0")) {
                mdbGenerator = new Ejb2MDBSourceGenerator(templateEngine);
                Ejb2MDBContext ejb2MDBContext = new Ejb2MDBContext();
                ejb2MDBContext.setClassName(actionName);
                ejb2MDBContext.setProcesserClassName(String.valueOf(actionName) + "Processer");
                mdbContext = ejb2MDBContext;
            } else {
                errorMessage = new StringBuffer();
                errorMessage.append("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 ejb version \uc785\ub2c8\ub2e4.\n");
                errorMessage.append("\uc785\ub825\ud55c \ubc84\uc804 : " + ejbVersion + " \uac00\ub2a5\ud55c \ubc84\uc804 : 2.0");
                Generator.Error(errorMessage.toString());
            }
            System.out.println("ServerDescriptionGenerator\ub97c \ucd08\uae30\ud654 \ud569\ub2c8\ub2e4.");
            if (serverType.equals("jeus5.0")) {
                serverDescriptionGenerator = new Jeus5ServerDescriptionGenerator(templateEngine);
                Jeus5ServerDescriptionContext jeus5ServerDescriptionContext = new Jeus5ServerDescriptionContext();
                jeus5ServerDescriptionContext.setEjbName(actionName);
                jeus5ServerDescriptionContext.setQueueConnectionFactoryName(queueConnectionFactoryName);
                jeus5ServerDescriptionContext.setDestination(actionName);
                serverDescriptionContext = jeus5ServerDescriptionContext;
            } else {
                errorMessage = new StringBuffer();
                errorMessage.append("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc11c\ubc84 \ud0c0\uc785 \uc785\ub2c8\ub2e4.\n");
                errorMessage.append("\uc785\ub825\ud55c \uc11c\ubc84 \ud0c0\uc785 : " + serverType + " \uac00\ub2a5\ud55c \uc11c\ubc84 \ud0c0\uc785 : jeus5.0");
                Generator.Error(errorMessage.toString());
            }
            System.out.println("ActionHandlerProcesserGenerator\ub97c  \ucd08\uae30\ud654 \ud569\ub2c8\ub2e4.");
            actionHandlerProcesserGenerator = new ActionHandlerProcesserGenerator(templateEngine);
            actionHandlerProcesserContext = new ActionHandlerProcesserContext();
            actionHandlerProcesserContext.setProcesserClassName(String.valueOf(actionName) + "Processer");
            System.out.println("----- \ucd08\uae30\ud654 -----");
            System.out.println();
            System.out.println("----- \uc0dd\uc131 -----");
            System.out.println("EjbJarGenerator \uc2e4\ud589\ud569\ub2c8\ub2e4.");
            ((EjbJarGenerator)ejbJarGenerator).generate(ejbJarContext, outputDirectory);
            System.out.println("MdbGenerator \uc2e4\ud589\ud569\ub2c8\ub2e4.");
            ((MDBSourceGenerator)mdbGenerator).generate(mdbContext, outputDirectory);
            System.out.println("ServerDescriptionGenerator \uc2e4\ud589\ud569\ub2c8\ub2e4.");
            ((ServerDescriptionGenerator)serverDescriptionGenerator).generate(serverDescriptionContext, outputDirectory);
            System.out.println("ActionHandlerProcesserGenerator \uc2e4\ud589\ud569\ub2c8\ub2e4.");
            actionHandlerProcesserGenerator.generate(actionHandlerProcesserContext, outputDirectory);
            System.out.println("----- \uc0dd\uc131 -----");
            System.out.println();
            System.out.println("\uc0dd\uc131 \ub514\ub809\ud1a0\ub9ac : " + outputDirectory);
            System.out.println("\uc0dd\uc131 \uc644\ub8cc");
        }
        catch (Throwable t) {
            Generator.Error(LogUtil.stackTraceToString((Throwable)t));
        }
    }
}

