module SHT71M {
	provides {
		interface SensorAPP;
	}
	uses {
		interface HALI2CInterface;
	}
}

implementation {
	uint8_t sensor_type = MEASURE_TEMP;

	uint8_t setSensorType(uint8_t type){
		if(type == MEASURE_TEMP || type == MEASURE_HUM)
			sensor_type = type;
		else
			return FAIL;

		return SUCCESS;
	}

	uint8_t getSensorType(){
		return sensor_type;
	}

	float readSensorData()
	{
		int8_t k = 0;
		uint16_t data;
		uint8_t cal_crc=0;

		call HALI2CInterface.dataOutput();	
		call HALI2CInterface.dataHigh();
		
		call HALI2CInterface.sckHigh();
		
		call HALI2CInterface.dataLow();
		
		TOSH_uwait(2);
		call HALI2CInterface.sckLow();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();


		call HALI2CInterface.dataHigh();

		TOSH_uwait(2);
		call HALI2CInterface.sckLow();
		TOSH_uwait(2);


		//-----------------------------------------------------
		// Transmission Command 	
		for(k = 7; k > -1 ; k--)
		{

			if((sensor_type >> k) & 0x01)
			  	call HALI2CInterface.dataHigh();
		  	else
			  	call HALI2CInterface.dataLow();

			TOSH_uwait(2);
			call HALI2CInterface.sckHigh();
			TOSH_uwait(2);
			call HALI2CInterface.sckLow();
		}

	  	call HALI2CInterface.dataInput();

		TOSH_uwait(2);

		call HALI2CInterface.sckHigh();
		while(call HALI2CInterface.dataRead());
		
		call HALI2CInterface.sckLow();

		TOSH_uwait(1000);
		//-----------------------------------------------------
		// Read Hum or Temp Value
		data = 0; //integer

		while(call HALI2CInterface.dataRead());

		for(k = 7; k > -1;k--)
		{
			data = data << 1;
			TOSH_uwait(2);
			call HALI2CInterface.sckHigh();
			data = (data | call HALI2CInterface.dataRead());
			TOSH_uwait(2);
			
			call HALI2CInterface.sckLow();
		}
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataLow();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckLow();

		call HALI2CInterface.dataInput();

		for(k = 7; k > -1;k--)
		{
			data = data << 1;
			TOSH_uwait(2);
			call HALI2CInterface.sckHigh();
			data = (data | call HALI2CInterface.dataRead());
			TOSH_uwait(2);
			
			call HALI2CInterface.sckLow();
		}

		data <<= 2;
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataLow();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckLow();

		call HALI2CInterface.dataInput();

		//-----------------------------------------------------
		// Read CRC
		cal_crc = 0;

		for(k = 7; k > -1;k--)
		{
			cal_crc = cal_crc << 1;
			TOSH_uwait(2);
			call HALI2CInterface.sckHigh();
			cal_crc = (cal_crc | call HALI2CInterface.dataRead());
			TOSH_uwait(2);
			
			call HALI2CInterface.sckLow();
		}
		cal_crc <<= 2;
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckLow();
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.sckLow();
		call HALI2CInterface.dataHigh();

		if(sensor_type == MEASURE_TEMP)
			return data/1000.0;
		else
			return data/100.0;

	} // Measurement

	void writeStatusReg(uint8_t reg)
	{
		int8_t k=0;
		uint8_t wr_command;

		wr_command = WR_STATUS_REG;

		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataHigh();
//TOSH_uwait(30000);
		call HALI2CInterface.sckHigh();
//TOSH_uwait(30000);
		call HALI2CInterface.dataLow();

		TOSH_uwait(2);
		call HALI2CInterface.sckLow();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
//TOSH_uwait(30000);
		call HALI2CInterface.dataHigh();

		TOSH_uwait(2);
		call HALI2CInterface.sckLow();
		TOSH_uwait(2);

		for(k=7;k>-1;k--)
		{
			if((wr_command >> k) & 0x01)
				call HALI2CInterface.dataHigh();
			else
				call HALI2CInterface.dataLow();
//TOSH_uwait(30000);
			call HALI2CInterface.sckHigh();
			TOSH_uwait(2);
			call HALI2CInterface.sckLow();
		}
//TOSH_uwait(30000);
		call HALI2CInterface.dataInput();
		TOSH_uwait(2);

		while(call HALI2CInterface.dataRead());

		call HALI2CInterface.sckHigh();

		call HALI2CInterface.dataOutput();

		TOSH_uwait(2);

		call HALI2CInterface.sckLow();
		TOSH_uwait(2);

		for(k=7;k>-1;k--)
		{
			if((reg >> k) & 0x01)
				call HALI2CInterface.dataHigh();
			else
				call HALI2CInterface.dataLow();

			call HALI2CInterface.sckHigh();
			TOSH_uwait(2);
			call HALI2CInterface.sckLow();
		}

		call HALI2CInterface.dataInput();
		TOSH_uwait(2);

		while(call HALI2CInterface.dataRead());
		call HALI2CInterface.sckHigh();

		call HALI2CInterface.dataOutput();
		call HALI2CInterface.sckLow();
		call HALI2CInterface.dataHigh();

		return;
	}

	uint8_t readStatusReg()
	{
		int8_t k=0;
		uint8_t reg;
		uint8_t cal_crc;
		uint8_t wr_command;

		wr_command = RD_STATUS_REG; // 0x07

		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataHigh();

		call HALI2CInterface.sckHigh();
		
		call HALI2CInterface.dataLow();
		
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();


		call HALI2CInterface.dataHigh();

		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);

		
		for(k = 7; k > -1 ; k--)
		{

			if((wr_command >> k) & 0x01)
			  	call HALI2CInterface.dataHigh();
		  	else
			  	call HALI2CInterface.dataLow();

			call HALI2CInterface.sckHigh();
			TOSH_uwait(2);
			call HALI2CInterface.sckHigh(); 
		}


	// modify by huy.  06.09.14
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataLow();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();

		call HALI2CInterface.dataInput();

		TOSH_uwait(1000);

		reg = 0;

		for(k = 7; k > -1;k--)
		{
			reg = reg << 1;
			TOSH_uwait(2);
			call HALI2CInterface.sckHigh();
			reg = (reg | call HALI2CInterface.dataRead());
			TOSH_uwait(2);
			
			call HALI2CInterface.sckHigh();
		}
		reg <<= 2;
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataLow();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();

		call HALI2CInterface.dataInput();

		//-----------------------------------------------------
		// Read CRC
		cal_crc = 0;

		for(k = 7; k > -1;k--)
		{
			cal_crc = cal_crc << 1;
			TOSH_uwait(2);
			call HALI2CInterface.sckHigh();
			cal_crc = (cal_crc | call HALI2CInterface.dataRead());
			TOSH_uwait(2);
			
			call HALI2CInterface.sckHigh();
		}
		cal_crc <<= 2;
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		TOSH_uwait(2);
		call HALI2CInterface.sckHigh();
		
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.sckHigh();
		call HALI2CInterface.dataHigh();

		return reg;	  		

	} // ReadStatusReg
	
	command result_t SensorAPP.open(){
		call HALI2CInterface.init();
		call HALI2CInterface.on();
		call HALI2CInterface.sckInit();
		call HALI2CInterface.sckLow();
		call HALI2CInterface.dataOutput();
		call HALI2CInterface.dataHigh();
		//call HALADCInterface.open();
		writeStatusReg(0);
		return SUCCESS;
	}

	command result_t SensorAPP.close(){
		call HALI2CInterface.off();
		return SUCCESS;
	}

	command result_t SensorAPP.read(){
		float read_data = 0;

		writeStatusReg(0);

		read_data = readSensorData();

		signal SensorAPP.readReady((void*)&read_data);
		//return call HALADCInterface.read();
		return SUCCESS;
	}

	command result_t SensorAPP.write(uint8_t data){
		//return call HALADCInterface.write(data);
		return SUCCESS;
	}

	command result_t SensorAPP.ioctl(uint8_t type, uint8_t request, uint8_t data){
		switch(type)
		{
		case SENSOR:
			if(request == SET_TYPE)
			{
				if(data == MEASURE_TEMP || data == MEASURE_HUM)
					setSensorType(data);
				else
					return FAIL;
			}
			else if(request == GET_TYPE)
			{
				return getSensorType();
			}
			break;
		default:
			return FAIL;
		}
		return SUCCESS;
	}

	default async event result_t SensorAPP.readReady(void *data) {
		return FAIL;
	}
	
	//async event result_t HALADCInterface.dataReady(uint16_t data) {
	//	signal SensorAPP.readReady(data);
	//	return SUCCESS;
	//}
	
}
