module RE200BM {
	provides {
		interface SensorAPP;
	}
	uses {
		interface HALINTRInterface;
	}
}

implementation {
	command result_t SensorAPP.open(){
		call HALINTRInterface.init();
		call HALINTRInterface.on();
		call HALINTRInterface.open();
		return SUCCESS;
	}

	command result_t SensorAPP.close(){
		call HALINTRInterface.off();
		return SUCCESS;
	}

	command result_t SensorAPP.read(){
		return call HALINTRInterface.read();
	}

	command result_t SensorAPP.write(uint8_t data){
		return call HALINTRInterface.write(data);
	}

	command result_t SensorAPP.ioctl(uint8_t kind, uint8_t type, uint8_t data){
		return call HALINTRInterface.ioctl(data);
	}

	default async event result_t SensorAPP.readReady(void *data) {
		return FAIL;
	}
	
	async event result_t HALINTRInterface.dataReady(uint16_t data) {
		signal SensorAPP.readReady((void*)&data);
		return SUCCESS;
	}
	
}

