module LM61M {
	provides {
		interface SensorAPP;
	}
	uses {
		interface HALADCInterface;
	}
}

implementation {
	command result_t SensorAPP.open(){
		call HALADCInterface.init();
		call HALADCInterface.on();
		call HALADCInterface.open();
		return SUCCESS;
	}

	command result_t SensorAPP.close(){
		call HALADCInterface.off();
		return SUCCESS;
	}

	command result_t SensorAPP.read(){
		return call HALADCInterface.read();
	}

	command result_t SensorAPP.write(uint8_t data){
		return call HALADCInterface.write(data);
	}

	command result_t SensorAPP.ioctl(uint8_t type, uint8_t request, uint8_t data){
		return call HALADCInterface.ioctl(data);
	}

	default async event result_t SensorAPP.readReady(void *data) {
		return FAIL;
	}
	
	async event result_t HALADCInterface.dataReady(uint16_t data) {
		signal SensorAPP.readReady((void*)&data);
		return SUCCESS;
	}
	
}
