module testM {
	provides {
		interface StdControl;
	}
	uses {
		interface Leds;
		interface Timer;
		interface SensorAPP;
	}
}
implementation {
	uint8_t led_data = 0;
	command result_t StdControl.init(){
		call Leds.redOff();
		call Leds.yellowOff();
		call Leds.greenOff();
		call SensorAPP.open();
		//call HALInterface.open();
		//call HALInterface.on();
		return SUCCESS;
	}

	command result_t StdControl.start(){
		return call Timer.start(TIMER_REPEAT, 1000);
	}

	command result_t StdControl.stop() {
		return call Timer.stop();
	}
	
	event result_t Timer.fired() {
		//call HALInterface.read();
		call SensorAPP.read();
		return SUCCESS;
	}

	//default async event result_t SensorAPP.readReady(uint16_t data) { return FAIL; }
	
	async event result_t SensorAPP.readReady(void *data){
		call Leds.yellowToggle();
		//call SensorAPP.readReady(data);
		
		return SUCCESS;
	}
}
