includes hal;

module HIINTRM {
	provides {
		interface HALINTRInterface;
	}
	uses {
		interface HALINTERRUPT;
		interface HALPPORT;
	}
}
implementation {
	command result_t HALINTRInterface.init(){
		return call HALPPORT.init(AB_PORTC | AB_PIN1, HIGH);
	}

	command result_t HALINTRInterface.on(){
		return call HALPPORT.on(AB_PORTC | AB_PIN1, HIGH);
	}

	command result_t HALINTRInterface.off(){
		return call HALPPORT.off(AB_PORTC | AB_PIN1, HIGH);
	}

	command result_t HALINTRInterface.open(){
		return call HALINTERRUPT.open(RIGING_EDGE);
	}

	command result_t HALINTRInterface.close(){
		return call HALINTERRUPT.close();
	}
	
	command result_t HALINTRInterface.read(){
		return call HALINTERRUPT.read();
	}

	command result_t HALINTRInterface.write(uint8_t cmd){
		return call HALINTERRUPT.write(cmd);
	}

	command result_t HALINTRInterface.ioctl(uint8_t data){
		return call HALINTERRUPT.ioctl(data);
	}

	default async event result_t HALINTRInterface.dataReady(uint16_t data){
		return FAIL;
	}
	async event result_t HALINTERRUPT.dataReady(){
		signal HALINTRInterface.dataReady(0);
		return SUCCESS;
	}
}

