includes hal;

module HII2CM {
	provides {
		interface HALI2CInterface;
	}
	uses {
		interface HALI2C;
		interface HALPPORT;
	}
}
implementation {
	command result_t HALI2CInterface.init(){
		return call HALPPORT.init(AB_PORTC | AB_PIN2, HIGH);
	}

	command result_t HALI2CInterface.on(){
		return call HALPPORT.on(AB_PORTC | AB_PIN2, HIGH);
	}

	command result_t HALI2CInterface.off(){
		return call HALPPORT.off(AB_PORTC | AB_PIN2, HIGH);
	}

	command result_t HALI2CInterface.sckInit(){
		return call HALI2C.sckInit(AB_PORTD | AB_PIN0);
	}

	command result_t HALI2CInterface.dataOutput(){
		return call HALI2C.dataOutput(AB_PORTD | AB_PIN1);
	}

	command result_t HALI2CInterface.dataInput(){
		return call HALI2C.dataInput(AB_PORTD | AB_PIN1);
	}

	command result_t HALI2CInterface.sckHigh(){
		return call HALI2C.sckHigh(AB_PORTD | AB_PIN0);
	}
	command result_t HALI2CInterface.sckLow(){
		return call HALI2C.sckLow(AB_PORTD | AB_PIN0);
	}

	command result_t HALI2CInterface.dataHigh(){
		return call HALI2C.dataHigh(AB_PORTD | AB_PIN1);
	}

	command result_t HALI2CInterface.dataLow(){
		return call HALI2C.dataLow(AB_PORTD | AB_PIN1);
	}
	
	command result_t HALI2CInterface.dataRead(){
		return call HALI2C.dataRead(AB_PORTD | AB_PIN1);
	}
}
