includes hal;

module HIADCVM {
	provides {
		interface HALADCInterface;
	}
	uses {
		interface HALADC;
		interface HALPPORT;
	}
}
implementation {
	command result_t HALADCInterface.init(){
		return call HALPPORT.init(AB_PORTC | AB_PIN0, HIGH);
	}

	command result_t HALADCInterface.on(){
		return call HALPPORT.on(AB_PORTC | AB_PIN0, HIGH);
	}

	command result_t HALADCInterface.off(){
		return call HALPPORT.off(AB_PORTC | AB_PIN0, HIGH);
	}

	command result_t HALADCInterface.open(){
		return call HALADC.open();
	}

	command result_t HALADCInterface.close(){
		return call HALADC.close();
	}
	
	command result_t HALADCInterface.read(){
		return call HALADC.read(AB_ADC1);
	}

	command result_t HALADCInterface.write(uint8_t cmd){
		return call HALADC.write(cmd);
	}

	command result_t HALADCInterface.ioctl(uint8_t data){
		return call HALADC.ioctl(data);
	}

	default async event result_t HALADCInterface.dataReady(uint16_t data){
		return FAIL;
	}
	async event result_t HALADC.dataReady(uint16_t data){
		signal HALADCInterface.dataReady(data);
		return SUCCESS;
	}
}

