module HALPPORTM {
	provides{
		interface HALPPORT;
	}
}

implementation {
	

	command result_t HALPPORT.init(uint8_t port, uint8_t enable){
		switch(port & 0xF0)
		{
		case 0x00:	sbi(DDRA, (port&0x0F));		break;
		case 0x10:	sbi(DDRB, (port&0x0F));		break;
		case 0x20:	sbi(DDRC, (port&0x0F));		break;
		case 0x30:	sbi(DDRD, (port&0x0F));		break;
		case 0x40:	sbi(DDRE, (port&0x0F));		break;
		case 0x50:	sbi(DDRF, (port&0x0F));		break;
		default :	break;
		}

		if(enable == 0x01)
		{
			switch(port & 0xF0)
			{
			case 0x00:	cbi(PORTA, (port&0x0F));	break;
			case 0x10:	cbi(PORTB, (port&0x0F));	break;
			case 0x20:	cbi(PORTC, (port&0x0F));	break;
			case 0x30:	cbi(PORTD, (port&0x0F));	break;
			case 0x40:	cbi(PORTE, (port&0x0F));	break;
			case 0x50:	cbi(PORTF, (port&0x0F));	break;
			default :	break;
			}
		}
		else if(enable == 0x00)
		{
			switch(port & 0xF0)
			{
			case 0x00:	sbi(PORTA, (port&0x0F));	break;
			case 0x10:	sbi(PORTB, (port&0x0F));	break;
			case 0x20:	sbi(PORTC, (port&0x0F));	break;
			case 0x30:	sbi(PORTD, (port&0x0F));	break;
			case 0x40:	sbi(PORTE, (port&0x0F));	break;
			case 0x50:	sbi(PORTF, (port&0x0F));	break;
			default :	break;
			}
		}
		else
		{
			return FAIL;
		}
		return SUCCESS;
		
	}

	command result_t HALPPORT.on(uint8_t port, uint8_t enable){
		if(enable == 0x01)
		{
			switch(port & 0xF0)
			{
			case 0x00:	sbi(PORTA, (port&0x0F));	break;
			case 0x10:	sbi(PORTB, (port&0x0F));	break;
			case 0x20:	sbi(PORTC, (port&0x0F));	break;
			case 0x30:	sbi(PORTD, (port&0x0F));	break;
			case 0x40:	sbi(PORTE, (port&0x0F));	break;
			case 0x50:	sbi(PORTF, (port&0x0F));	break;
			default :	break;
			}
		}
		else if(enable == 0x00)
		{
			switch(port & 0xF0)
			{
			case 0x00:	cbi(PORTA, (port&0x0F));	break;
			case 0x10:	cbi(PORTB, (port&0x0F));	break;
			case 0x20:	cbi(PORTC, (port&0x0F));	break;
			case 0x30:	cbi(PORTD, (port&0x0F));	break;
			case 0x40:	cbi(PORTE, (port&0x0F));	break;
			case 0x50:	cbi(PORTF, (port&0x0F));	break;
			default :	break;
			}
		}
		else
		{
			return FAIL;
		}
		return SUCCESS;
	}

	command result_t HALPPORT.off(uint8_t port, uint8_t enable){
		if(enable == 0x01)
		{
			switch(port & 0xF0)
			{
			case 0x00:	cbi(PORTA, (port&0x0F));	break;
			case 0x10:	cbi(PORTB, (port&0x0F));	break;
			case 0x20:	cbi(PORTC, (port&0x0F));	break;
			case 0x30:	cbi(PORTD, (port&0x0F));	break;
			case 0x40:	cbi(PORTE, (port&0x0F));	break;
			case 0x50:	cbi(PORTF, (port&0x0F));	break;
			default :	break;
			}
		}
		else if(enable == 0x00)
		{
			switch(port & 0xF0)
			{
			case 0x00:	sbi(PORTA, (port&0x0F));	break;
			case 0x10:	sbi(PORTB, (port&0x0F));	break;
			case 0x20:	sbi(PORTC, (port&0x0F));	break;
			case 0x30:	sbi(PORTD, (port&0x0F));	break;
			case 0x40:	sbi(PORTE, (port&0x0F));	break;
			case 0x50:	sbi(PORTF, (port&0x0F));	break;
			default :	break;
			}
		}
		else
		{
			return FAIL;
		}
		return SUCCESS;
	}

}
