module HALADCM {
	provides {
		interface HALADC;
	}
}

implementation {

	command result_t HALADC.open(){
		atomic {
			outp(((1<<ADIE) | (6<<ADPS0)), ADCSR);

			outp(0xC0,ADMUX);
		}
		return SUCCESS;
	}

	command result_t HALADC.close(){
		return SUCCESS;
	}

	command result_t HALADC.read(uint8_t port){
		atomic {
			outp(((port | 0xC0) & 0xDF), ADMUX);
		}
		sbi(ADCSR, ADEN);
		sbi(ADCSR, ADSC);
		
		return SUCCESS;
	}

	command result_t HALADC.write(uint8_t cmd){
		return SUCCESS;
	}

	command result_t HALADC.ioctl(uint8_t data){
		return SUCCESS;
	}

	default async event result_t HALADC.dataReady(uint16_t data) { return SUCCESS;}

	TOSH_SIGNAL(SIG_ADC){
		uint16_t data = inw(ADCL);
		data &= 0x03FF;
		sbi(ADCSR, ADIF);
		cbi(ADCSR, ADEN);
		__nesc_enable_interrupt();
		signal HALADC.dataReady(data);
	}
}
