//========================================================================
// File		: hal.c 
// Author	: Youngbum Park (youngbumpark@gmail.com)
// Date		: 2008.08.08
// Description : hal layer process test (ADC)
//========================================================================
// Copyright 2008 - 2014, HCI Lab
//========================================================================

//-------------- Terminal setting -----------------------
// Data bit		: 8 bit
// Stop bit		: 1 bit
// Parity		: none
//-------------------------------------------------------

#include "nos.h"

#define ADC_V3			0
#define INTERRUPT_V3	1

int main (void)
{
	UINT16 temp_value = 0;
	nos_init();
	uart_printf("\n Octacomm Sensor Hardware Interface Board Test \n");
	//A9060_func_connect();

	device_connect("light_dve","adcv_v1_0","TE100");

	a9060_init(ADC_V3);
	led_on(3);
	
	//a9060_test(ADC_V3);
	
	while (1)
	{
		a9060_power_on(ADC_V3);
		uart_printf("ADC_V3 power ON\n");
		uart_printf("Get A9060 temp data : %u\n",a9060_data_read(ADC_V3));
		led_toggle(4);
		delay_ms(1000);
		a9060_power_off(ADC_V3);
		uart_printf("ADC_V3 power OFF\n");
		delay_ms(1000);
	}
	a9060_power_off(ADC_V3);

	return 0;
}

