//========================================================================
// File		: uart_put.c 
// Author	: Haeyong Kim (haekim@etri.re.kr), sheart@etri.re.kr
// Date		: 2006.06.01
// Description : Print charater on the terminal (STDOUT).
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================

//-------------- Terminal setting -----------------------
// Data bit		: 8 bit
// Stop bit		: 1 bit
// Parity		: none
//-------------------------------------------------------

#include "nos.h"

int main (void)
{
	UINT8 i;
	UINT8 tilde = '~';
	UINT8 name[] = "Nano OS";
	UINT8 kor_name[]=" OS";
	nos_init();

	// print string
	uart_printf("\n*** %s (Korean: %s) ***\n", name, kor_name);

	// print 16-bit integer (-32768~32767, 2's complement)
	uart_printf("\nINT16 : %d %c %i",-32768, tilde, 32767);	// %d = %i
	uart_puts("\nINT16 : ");	//print string
	uart_puti(-32768);
	uart_putc(tilde);	// print character
	uart_puti(32767);

	// print 16-bit unsigned integer (0~65535)
	uart_printf("\nUINT16 : %u ~ %u", 0, 65535);
	uart_puts("\nUINT16 : ");
	uart_putu(0);
	uart_putc('~');
	uart_putu(65535);

	// print 16-bit unsigned hexadecimal (0x0000~ 0xffff)
	uart_printf("\nHex16 : %x ~ %x", 0x0000, 0xFFFF);

	// print 16-bit unsigned octal
	uart_printf("\nOctal16 : %o ~ %o\n\n", 0x0000, 0xFFFF);

	while (1)
	{
		// print character
		for (i=0; i<5; i++)
		{
			uart_putc('-');
			delay_ms(200); // wait for 200 ms
		}
		for (i=0; i<5; i++)
		{
			// Backspace key handling
			uart_putc(_BS);	// Backspace character '_BS' = 0x08
			uart_putc(' ');	
			uart_putc(_BS);
			delay_ms(200); // wait for 200 ms
		}
		
	}

	return 0;
}
