//===================================================================
//
// reno_tx.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

// TX thread 
void task1(void* args)
{
	UINT8 i;
	UINT8 data[NWK_MAX_PAYLOAD_SIZE]; //108
	// dummy data
	for (i=0; i<NWK_MAX_PAYLOAD_SIZE; ++i)
	{
		data[i]=i;
	}
	while (TRUE)
	{
		led_toggle(2);		
		data[0] = ++i;
		nwk_tx(1, NWK_MAX_PAYLOAD_SIZE, data);
		uart_printf("\nTX : %u", i);
	}
}

int main(void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ] 
	nwk_init(0x1A, 0x312, 2, 0, 255);
 	uart_printf("RF Channel : 0x1A \nPAN address: 0x312 \nID : 2\nReceivable Range : 0 ~ 255\n");

	thread_create(task1, NULL, 108, PRIORITY_NORMAL);	// stack size is 108 not 0 because of data[] in task1.

	sched_start();

	return 0;
} // main
