//===================================================================
//
// rx-non-callback.c (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "nos.h"

NMAC_RX_INFO rx_info;
UINT8 rx_payload[NMAC_MAX_PAYLOAD_SIZE];


void task1(void *args)
{
    while (TRUE)
    {
		if( mac_rx(&rx_info) )
		{
			led_toggle(3);
			uart_printf("RX : %u, \tRSSI(%d),\tCorr(%d)\n",((UINT8*)(rx_info.payload_ptr))[0], rx_info.rssi, rx_info.corr );
		}
    }
}


int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	rx_info.payload_ptr = rx_payload;

	mac_init(0x1A, 0x2420, 0x5678); // channel=26, PAN id = 0x2420, node id = 0x5678 (B)
	//mac_set_tx_power(31); //default
	//mac_set_rx_range(0x0000, 0xffff);
	
	thread_create(task1, NULL, 0, PRIORITY_NORMAL);
 	sched_start();
	
    return 0;
}
