//========================================================================
// File		: msgq.c 
// Author	: @sheart
// Date		: 2006.06.01
// Description : message queue test program. 
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

MSGQ	mq;
UINT8 	id1, id2;

void task1(void *args)
{
	UINT16 data = 0;
	UINT8 status;
	UINT8 j;

        while (1)
        {
		status = msgq_isend(mq, &data);
		if (status == MSGQ_FULL_ERROR)
		{
			uart_printf("Message Queue Full Error data %d dropped\n", data);
			
			// process something even if it is error
			for (j=0; j<10; j++) uart_printf("%d", j);
			uart_printf("\n");

			// try to send it again until completion.
			msgq_send(mq, &data);
			uart_printf("\nTask1 : TX %d \n", data);
		}
		else
			uart_printf("\nTask1 : TX %d \n", data);

		if (data%20 < 10)
		{
			thread_sleep_ms(500);
		}
		else
		{
			thread_sleep_ms(1000);
		}
			

		data++;
	}
}

void task2(void *args)
{
	UINT16 data;
	UINT8 status;
	INT8  j;

        while (1)
        {
		status = msgq_irecv(mq, &data); // immediately returns even if data is not received
		if (status == MSGQ_EMPTY_ERROR)
		{
			uart_printf("Message Queue Empty Error. No data received\n");

			// processing something although message queue is full 
			for (j=9; j>=0; j--) uart_printf("%d", j);
				uart_printf("\n");

			// try to receive it again until completion.
			msgq_recv(mq, &data);
			uart_printf("Task2 : RX %d \n", data);
		}
		else
			uart_printf("Task2 : RX %d \n", data);

		if (data%20 < 10)
		{
			thread_sleep_ms(2000);
		}
		else
		{
			thread_sleep_ms(100);
		}
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	uart_printf("\n=== Message queue test program ===\n");

	mq = msgq_create(MSGQ_UINT16, 5); // create a msgq with an array of 5 integers (total 10 bytes)

	id1 = thread_create(task1, NULL, 0, PRIORITY_NORMAL);
	id2 = thread_create(task2, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
