//========================================================================
// File		: msgq.c 
// Author	: @sheart
// Date		: 2006.06.01
// Description : message queue test program. 
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

MSGQ	mq;
UINT8 id1, id2, id3;

void task1(void *args)
{
	UINT16 data = 0;

        while (1)
        {
		uart_printf("\nTask1 : TX trying.....\n");

		if (msgq_send(mq, &data) == MSGQ_NO_ERROR) // blocking send
			uart_printf("Task1 : TX %d succeeded\n", data++);
		else
			uart_printf("Task1 : TX failed. Serious!\n");
		
		thread_sleep_sec(1);
        }
}

void task2(void *args)
{
	UINT16 data;

        while (1)
        {
		uart_printf("\nTask2 : RX trying.....\n");
		if (msgq_recv(mq, &data) == MSGQ_NO_ERROR)  // blocking receive
			uart_printf("Task2 : RX %d \n", data);
		else
			uart_printf("Task2 : RX failed.\n");
			
		thread_sleep_sec(4);
        }
}

void task3(void *args)
{
	UINT16 data;

        while (1)
        {
		uart_printf("\nTask3 : RX trying.....\n");
		if (msgq_recv(mq, &data) == MSGQ_NO_ERROR)  // blocking receive
			uart_printf("Task3 : RX %d \n", data);
		else
			uart_printf("Task3 : RX failed.\n");

		uart_printf("Task3 : RX %d \n", data);
		thread_sleep_sec(4);
        }
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	uart_printf("\n=== Message queue test program ===\n");

	mq = msgq_create(MSGQ_UINT16, 5); // create a msgq with an array of 5 integers (total 10 bytes)

	id1 = thread_create(task1, NULL, 0, PRIORITY_NORMAL);
	id2 = thread_create(task2, NULL, 0, PRIORITY_NORMAL);
	id3 = thread_create(task3, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
