//========================================================================
// File		: sem.c 
// Author	: @jun361
// Date		: 2006.06.01
// Description : semaphore test program. 
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

void task(void *);
void do_loop(UINT8 id);

SEMAPHORE sem;

void do_loop(UINT8 id)
{
	UINT8 i,j;
	for (i=1; i<10; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void task(void *args)
{
	UINT8 myid;

	myid = get_thread_id();
        while (1)
        {
		// only 2 threads are allowed
		sem_wait(sem);
		/////////////////////////////// This is critical section (begin)
		do_loop(myid);
		/////////////////////////////// This is critical section (end)
		sem_signal(sem);
		thread_sleep(1);
        }
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	uart_printf("\n=== Semaphore test program ===\n");

	sem = sem_create(2); // counting semaphore

	thread_create(task, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(task, NULL, 0, PRIORITY_NORMAL); 
	thread_create(task, NULL, 0, PRIORITY_NORMAL);
	thread_create(task, NULL, 0, PRIORITY_NORMAL);
	thread_create(task, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
