//========================================================================
// File		: binary_sem.c 
// Author	: @jun361
// Date		: 2006.06.01
// Description : semaphore test program. 
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

SEMAPHORE sem;

void do_loop(UINT8 id)
{
	UINT8 i,j;
	for (i=1; i<10; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void task1(void *args)
{
        while (1)
        {
		sem_wait(sem);
		do_loop(1);
		sem_signal(sem);	// If there are threads that are of same priority, context switch occurs.
		thread_sleep_sec(1);
        }
}

void task2(void *args)
{
        while (1)
        {
		sem_wait(sem);
		do_loop(2);
		sem_signal(sem);
		thread_sleep_sec(2);
        }
}

void task3(void *args)
{
        while (1)
        {
		sem_wait(sem);
		do_loop(3);
		sem_signal(sem);
		thread_sleep_sec(3);
        }
}

void task4(void *args)
{
        while (1)
        {
		sem_wait(sem);
		do_loop(4);
		sem_signal(sem);
		thread_sleep_sec(4);
        }
}

void task5(void *args)
{
        while (1)
        {
		sem_wait(sem);
		do_loop(5);
		sem_signal(sem);
		thread_sleep_sec(5);
        }
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	uart_printf("\n=== Semaphore test program ===\n");

	sem = sem_create(1); // binary semaphore

	thread_create(task1, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	thread_create(task3, NULL, 0, PRIORITY_NORMAL);
	thread_create(task4, NULL, 0, PRIORITY_NORMAL);
	thread_create(task5, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}

