//========================================================================
// File		: scheduling_control.c
// Author	: haekim@etri.re.kr
// Date		: 2006.10.26
// Description : Various methods to control scheduling
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================

//-------------------------------------------------------------------------------------
// 1. "ENTER_CRITICAL" delays scheduling. (A scheduling timer interrupt will be called right after critical section.)
// 2. "disable_sched" ignores scheduling. (A scheduling interrupt is executed, but does not switch context.)
// 3.  You can also use binary semaphore.
//-------------------------------------------------------------------------------------

#include "nos.h"

void do_loop(UINT8 id)
{
	UINT8 i,j;
	for (i=1; i<10; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void task1(void *args)
{
	while (1)
	{
		disable_sched();
		do_loop(1);
		enable_sched();
		context_sw(); // force to context switch
	}
}

void task2(void *args)
{
	while (1)
	{
		disable_sched();
		do_loop(2);
		enable_sched();
		thread_sleep(1); // force to context switch
	}
}

void task3(void *args)
{
	while (1)
	{
		ENTER_CRITICAL();
		do_loop(3);
		EXIT_CRITICAL();
	}
}

void task4(void *args)
{
	while (1)
	{
		disable_sched();
		do_loop(4);
		enable_sched();
		delay_ms(50); // give a short time to be context switched swiftly before disabling context switch() again.
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	thread_create(task1, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	thread_create(task3, NULL, 0, PRIORITY_NORMAL);
	thread_create(task4, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
