//========================================================================
// File		: thread_suspend_resume.c 
// Author	: @sheart
// Date		: 2006.10.01
// Description : Suspend Resume Test Program
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

UINT8 task1_id;

void do_loop(UINT8 id)
{
	UINT8 i,j;
	for (i=1; i<10; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void task1(void *args)
{
	while (1)
	{
		do_loop(task1_id);
		uart_printf("\n\n===Task%d : I suspend myself now.===\n", task1_id);
		// self suspend
		thread_suspend(task1_id);
	}
}

void task2(void *args)
{
	UINT8 my_id = get_thread_id();
	while (1)
	{
		do_loop(my_id);
		do_loop(my_id);
		do_loop(my_id);
		uart_printf("\n\n===Task%d : I resume Task1 now.===\n", my_id);
		thread_resume(task1_id);
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	task1_id = thread_create(task1, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	sched_start();

   	return 0;
}
