//========================================================================
// File		: sleep_wakeup.c 
// Author	: @jun361, @sheart, @haekim
// Date		: 2007.11.14
// Description : "thread_sleep" and "thread_wakeup" test program.
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

void print_myid(UINT8 id, UINT8 sleep_sec)
{
	uart_printf("Thread %d : I will sleep for %d sec(s).\n", id, sleep_sec);
}


void task2(void *args)
{
	while (1)
	{
		print_myid(2,5);
		thread_sleep_ms(5000);
	}
}

void task3(void *args)
{
	while (1)
	{
		print_myid(3,10);
		thread_sleep_sec(10);
	}
}

void task4(void *args)
{
	while (1)
	{
		print_myid(4,20);
		thread_sleep_sec(20);
	}
}

void task1(void *args)
{
	UINT8 i, thread2_id, thread3_id, thread4_id;
	thread2_id=thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	thread3_id=thread_create(task3, NULL, 0, PRIORITY_NORMAL);
	thread4_id=thread_create(task4, NULL, 0, PRIORITY_NORMAL);
	while (1)
	{
		uart_printf("\n==Thread sleep test for 20 secs==\n");
		for (i=0; i<20; ++i)
		{
			print_myid(1,1);
			thread_sleep_sec(1);
		}
		delay_ms(1000);

		uart_printf("\n==Thread wake up test==\n");
		uart_printf("I am thread 1. I will wake up the other threads.\n");
		delay_ms(1000);

		uart_printf("Thread 1 : wake up thread 2.\n");
		thread_wakeup(thread2_id);
		delay_ms(1000);

		uart_printf("Thread 1 : wake up thread 3.\n");
		thread_wakeup(thread3_id);
		delay_ms(1000);

		uart_printf("Thread 1 : wake thread 4 up.\n");
		thread_wakeup(thread4_id);
		delay_ms(1000);
	}
}


int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	thread_create(task1, NULL, 0, PRIORITY_NORMAL); 	

	sched_start();

   	return 0;
}
