//========================================================================
// File		: create_exit.c
// Author	: @jun361, @sheart, @haekim
// Date		: 2007.11.14
// Description : "thread_create" and "thread_exit" test program. "thread_exit" is called by kernel automatically when it returns.
//			User thread can be created up to 5 threads or 15 threads with thread_ext module.
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

void do_loop(UINT8 id)
{
	UINT8 i,j;
	for (i=1; i<10; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void new_task(void *args)
{
	UINT8 my_id = get_thread_id();
	UINT8 my_value = *((UINT8 *)args);
	uart_printf("\n===A new Task%d has been created by Task%d.===", my_id, my_value);
	do_loop(my_id);
	uart_printf("\n===Task%d has exited.===\n", my_id);
	//"thread_exit()" will be called.
}

void task1(void *args)
{
	UINT8 my_id = get_thread_id();
	while (1)
	{
		do_loop(my_id);
		if (thread_create(new_task, &my_id, 0, PRIORITY_NORMAL) < 0)
			uart_printf("\n===Task%d has failed to create a new thread.===",my_id);
	}
}

void task2(void *args)
{
	UINT8 my_id = get_thread_id();
	while (1)
	{
		do_loop(my_id);
		if (thread_create(new_task, &my_id, 0, PRIORITY_NORMAL) < 0)
			uart_printf("\n===Task%d has failed to create a new thread.===",my_id);
	}
}

void task3(void *args)
{
	UINT8 my_id = get_thread_id();
	while (1)
	{
		do_loop(my_id);
		if (thread_create(new_task, &my_id, 0, PRIORITY_NORMAL) < 0)
			uart_printf("\n===Task%d has failed to create a new thread.===",my_id);
	}
}


int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	thread_create(task1, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	thread_create(task3, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
