//===================================================================
//
// led.h	(@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef LED_H
#define LED_H
#include "kconf.h"
#ifdef LED_M

#include "common.h"

#define NOS_LED_INIT() \
	do { \
		_BIT_SET(P5DIR, RLED); \
		_BIT_SET(P5DIR, GLED); \
		_BIT_SET(P5DIR, YLED); \
		_BIT_CLR(P5SEL, RLED); \
		_BIT_CLR(P5SEL, GLED); \
		_BIT_CLR(P5SEL, YLED); \
		_BIT_SET(P5OUT, RLED); \
		_BIT_SET(P5OUT, GLED); \
		_BIT_SET(P5OUT, YLED); \
	} while(0)
	
#define NOS_LED_ON(n) \
	do { \
		if ( n == 1 ) \
			_BIT_CLR(P5OUT, RLED); \
		else if ( n == 2 ) \
			_BIT_CLR(P5OUT, GLED); \
		else if ( n == 3 ) \
			_BIT_CLR(P5OUT, YLED); \
		else { \
			_BIT_CLR(P5OUT, RLED); \
			_BIT_CLR(P5OUT, GLED); \
			_BIT_CLR(P5OUT, YLED); \
		} \
	} while(0)

#define NOS_LED_OFF(n) \
	do { \
		if ( n == 1 ) \
			_BIT_SET(P5OUT, RLED); \
		else if ( n == 2 ) \
			_BIT_SET(P5OUT, GLED); \
		else if ( n == 3 ) \
			_BIT_SET(P5OUT, YLED); \
		else { \
			_BIT_SET(P5OUT, RLED); \
			_BIT_SET(P5OUT, GLED); \
			_BIT_SET(P5OUT, YLED); \
		} \
	} while(0)
	
#define NOS_LED_TOGGLE(n) \
	do { \
		if ( n == 1 ) \
			P5OUT = P5IN^(1 << RLED); \
		else if ( n == 2 ) \
			P5OUT = P5IN^(1 << GLED); \
		else if ( n == 3 ) \
			P5OUT = P5IN^(1 << YLED); \
		else { \
			P5OUT = P5IN^(1 << RLED); \
			P5OUT = P5IN^(1 << GLED); \
			P5OUT = P5IN^(1 << YLED); \
		} \
	} while(0)

#endif // LED_M
#endif // ~LED_H
