//===================================================================
//
// platform.h   (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"
#include <io.h>

#define SPI_PORT0			1	// Use port0. 
//#define SPI_PORT1			1	// Use port1. 
#define SPI_ENABLE()		do { _BIT_CLR(P1OUT, CSN); } while (0)
#define SPI_DISABLE()		do { _BIT_SET(P1OUT, CSN); } while (0)
#define SIMO                    SIMO0 // P3.1 - Output: SIMO (Slave Input Master Output)
#define SOMI                    SOMI0 // P3.2 - Input: SOMI (Slave Output Master Input)
#define SCK                     UCLK0 // P3.3 - Output: SCK (UCLK0)

#ifdef UART_M
#include "uart.h"
#define STDIN   1
#define STDOUT  1
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif


#ifdef LED_M
#include "led.h"
#endif

#ifdef SENSOR_LIGHT_M
#include "sensor_light.h"
#endif

/*
#ifdef USER_BUTTON_M
#include "button.h"	// User button. normally "RESET".
#endif
*/

void nos_platform_init(void);

/*********************** PORT Definition ******************************/
// Port 1
#define FIFOP                   0 // P1.0 
#define FIFO                    3 // P1.3 - FIFO Access 
#define CCA                     4 // P1.4 - Input:  CCA from CC2420
#define SFD                     5 // P1.5 - Input:  SFD from CC2420
#define CSN                     6 // P1.6 - Output: SPI Chip Select (CS_N)
#define VREG_EN         		7 // P1.7 - CC2420 voltage regulator enable

// Port 2
#define RESET_N         	0 // P2.0 - CC2420 reset  
#define USER_INTR         	1 // P2.1 - Left side push-button is connected to interrupt pin. 
#define ONEWIRE_SERIAL_ID		3 //P2.3 - 1-Wire : serial id check

// Port 3

// Port 4
#define RLED			2 // P4.2
#define LIGHT_SENSOR_POWER_SW	3 // P4.3 - LIGHT Sensor power
#define PIEZO_PWM		4 // P4.4

// Port 6
#define ADC_LIGHT_CHANNEL	0 // P6.0 - ADC 0 IN

#endif	// PLATFORM_H
