//===================================================================
//
// led.h	(@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef LED_H
#define LED_H
#include "kconf.h"
#ifdef LED_M

#include "common.h"

#define NOS_LED_INIT() \
	do { \
		_BIT_SET(P4DIR, RLED); \
		_BIT_CLR(P4SEL, RLED); \
		_BIT_SET(P4OUT, RLED); \
	} while(0)
	
#define NOS_LED_ON(n) \
	do { \
		if ( n == 1 ) \
			_BIT_CLR(P4OUT, RLED); \
	} while(0)

#define NOS_LED_OFF(n) \
	do { \
		if ( n == 1 ) \
			_BIT_SET(P4OUT, RLED); \
	} while(0)
	
#define NOS_LED_TOGGLE(n) \
	do { \
		if ( n == 1 ) \
			P4OUT = P4IN^(1 << RLED); \
	} while(0)

#endif // LED_M
#endif // ~LED_H
