//===================================================================
//
// sensor_temp.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SENSOR_TEMP_H
#define SENSOR_TEMP_H
#include "kconf.h"
#ifdef SENSOR_TEMP_M 

#include "common.h"

#define NOS_TEMP_POWER_ON()     do { _BIT_CLR(P1OUT, SCL); } while(0)  // ETS300
#define NOS_TEMP_POWER_OFF()    do { _BIT_SET(P1OUT, SCL); } while(0)

#define CMD_RESET	0x1e
#define CMD_TEMP_ADDR	3

void nos_temp_init(void);
INT8 temp_port_get_data(void);
void temp_port_int_enable(void);
void reset(void);
void initseq(void);
INT8 processCommand(int);
void ack(void);
void readSensor(void);
UINT16 nos_temp_get_data(void);

#endif // SENSOR_TEMP_M
#endif // ~SENSOR_TEMP_H
