//===================================================================
//
// sensor_hum.c (@sheart,@jun361)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "sensor_hum.h"

#ifdef SENSOR_HUM_M
#include <signal.h>
#include "adc.h"
#include "platform.h"
#include "arch.h"

UINT16 data;

INT8 hum_port_get_data()
{
	return (P1IN & (1 << SDA));
}

void hum_port_int_enable()
{
	_BIT_CLR(P1DIR, SDA);
	_BIT_SET(P1OUT, SDA);
	P1IE &= ~(1 << 0);
	P1IFG &= ~(1 << 0);
	P1IES |=  (1 << 0);
	P1IE |= (1 << 0);
}
		
void reset()
{
    	UINT8 i;
    	_BIT_SET(P1DIR, SDA);
    	_BIT_SET(P1OUT, SDA);
    	_BIT_CLR(P1OUT, SCL);
    	for (i=0;i<9;i++) {
      	_BIT_SET(P1OUT, SCL);
       	nos_delay_ms(1);
      	_BIT_CLR(P1OUT, SCL);
    	}
}

void initseq()
{
   	_BIT_SET(P2DIR, SDA);
   	_BIT_SET(P2OUT, SDA);
   	_BIT_CLR(P1OUT, SCL);
   	nos_delay_ms(1);
   	_BIT_SET(P1OUT, SCL);
   	nos_delay_ms(1);
   	_BIT_CLR(P1OUT, SDA);
   	nos_delay_ms(1);
   	_BIT_CLR(P1OUT, SCL);
   	nos_delay_ms(1);
   	_BIT_SET(P1OUT, SCL);
   	nos_delay_ms(1);
   	_BIT_SET(P1OUT, SDA);
   	nos_delay_ms(1);
   	_BIT_CLR(P1OUT, SCL);
}

INT8 processCommand(int cmd)
{
    	INT16 i;

    	cmd &= 0x1f;
    	P1IE &= ~(1 << 0);
    	reset();
    	initseq();        //sending the init sequence

    	for (i=0;i<8;i++)
	{
      		if (cmd & 0x80) _BIT_SET(P1OUT, SDA);
      		else _BIT_CLR(P1OUT, SDA);

      		cmd = cmd << 1 ;
		_BIT_SET(P1OUT, SCL);
      		nos_delay_ms(1);
      		nos_delay_ms(1);
      		_BIT_CLR(P1OUT, SCL);
    	}

        _BIT_CLR(P1DIR, SDA);
    	_BIT_SET(P1OUT, SDA);
    	nos_delay_ms(1);
    	_BIT_SET(P1OUT, SCL);
    	nos_delay_ms(1);

    	if (hum_port_get_data())
    	{
    		reset();
		return 0;
    	}

    	nos_delay_ms(1);
    	_BIT_CLR(P1OUT, SCL);
    	hum_port_int_enable();

    	return 1;
}

void ack()
{
  	_BIT_SET(P1DIR, SDA);
  	_BIT_CLR(P1OUT, SDA);
  	nos_delay_ms(1);
  	_BIT_SET(P1OUT, SCL);
  	nos_delay_ms(1);
  	_BIT_CLR(P1OUT, SCL);
  	_BIT_CLR(P1DIR, SDA);
  	_BIT_SET(P1OUT, SDA);
}

void readSensor()
{
   	INT8 i;

   	data = 0;

   	for (i=0;i<8;i++)
	{
     		_BIT_SET(P1OUT, SCL);
     		nos_delay_ms(1);
     		if (hum_port_get_data())
       		data |= 1;
     		data = data << 1;
     		_BIT_CLR(P1OUT, SCL);
   	}

   	ack();

   	for (i=0;i<8;i++)
	{
     		_BIT_SET(P1OUT, SCL);
     		nos_delay_ms(1);
     		if (hum_port_get_data())
       		data |= 1;
     		//the last byte of data should not be shifted
     		if(i!=7) data = data << 1;
     		_BIT_CLR(P1OUT, SCL);
   	}

   	ack();

   	for (i=0;i<8;i++)
	{
     		_BIT_SET(P1OUT, SCL);
     		nos_delay_ms(1);
     		_BIT_CLR(P1OUT, SCL);
   	}

   	// nack with high as it should be for the CRC ack
   	_BIT_SET(P1DIR, SDA);
   	_BIT_SET(P1OUT, SDA);
   	nos_delay_ms(1);
   	_BIT_SET(P1OUT, SCL);
   	nos_delay_ms(1);
   	_BIT_CLR(P1OUT, SCL);
}

void nos_hum_init()
{
	_BIT_SET(P1DIR, SCL);
	_BIT_CLR(P1OUT, SCL);

	_BIT_CLR(P1DIR, SDA);
	_BIT_SET(P1OUT, SDA);

	//P2IE |= (1 << 0); // Interrupt enable
	P1IE &= ~(1 << 0); // Interrupt disable
	reset();
	processCommand(CMD_RESET);
}

UINT16 nos_hum_get_data()
{
	processCommand(CMD_HUM_ADDR);

	return data;
}

interrupt (PORT1_VECTOR) INT_P1 (void)
{
	P1IE &= ~(1 << 0); // Interrupt disable
	readSensor();
}
#endif
