//===================================================================
//
// platform.h	(@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#include <avr/io.h>

#include "hal.h"

#ifdef UART_M
#include "uart.h"
#define STDIN	1
#define STDOUT	1
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef LM61_M
#include "lm61.h"
#endif

#define SPI_ENABLE()		do { _BIT_CLR(PORTB, CSN); } while (0)
#define SPI_DISABLE()	do { _BIT_SET(PORTB, CSN); } while (0)

extern MappingTable *nos_mappingTable;
void nos_platform_init(void);

#define DEV_MAX 3	

/*********************** PORT Definition ******************************/
// Port A

// Port B
#define CSN			0 // PB.0 - Output: SPI Chip Select (CS_N)
#define SCK			1 // PB.1 - Output: SPI Serial Clock (SCLK)
#define MOSI			2 // MOSI - Output: SPI Master out - slave in (MOSI)
#define MISO			3 // MISO - Input:  SPI Master in - slave out (MISO)
#define RESET_N		4 // PB.4 - CC2420 reset  
#define VREG_EN		5 // PB.5 - CC2420 voltage regulator enable

// Port C

// Port D
#define FIFOP		0 // INT0 - Input:  FIFOP from CC2420
#define FIFO			1 // INT1 - Input:  FIFO from CC2420
#define UART1_RXD	2 // RXD1 - Input:  UART1 RXD
#define UART1_TXD	3 // TXD1 - Output: UART1 TXD
#define SFD			4 // ICP1 - Input:  SFD from CC2420
#define CCA			6 // PD.6 - Input:  CCA from CC2420

// Port E

// Port F

#endif	// ~PLATFORM_H

