//===================================================================
//
// platform.h	(@ybpark)
//
//===================================================================
// Copyright 2004-2010, HCI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#include <avr/io.h>

#include "hal.h"

#ifdef UART_M
#include "uart.h"
#define STDIN	0
#define STDOUT	0
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef BUTTON_M
#include "button.h"
#endif

#define SPI_ENABLE()	do { _BIT_CLR(PORTB, CSN); } while (0)
#define SPI_DISABLE()	do { _BIT_SET(PORTB, CSN); } while (0)

#define DEV_MAX 		3

void nos_platform_init(void);

extern MappingTable *nos_mappingTable;


/*********************** PORT Definition ******************************/
// Port A
#define LED3		3 // LED1 - Output

// Port B
#define CSN			0 // PB.0 - Output: SPI Chip Select (CS_N)
#define SCK			1 // PB.1 - Output: SPI Serial Clock (SCLK)
#define MOSI		2 // MOSI - Output: SPI Master out - slave in (MOSI)
#define MISO		3 // MISO - Input:  SPI Master in - slave out (MISO)
#define RESET_N		4 // PB.4 - CC2420 reset  
#define VREG_EN		7 // PB.5 - CC2420 voltage regulator enable

// Port C
#define LED4		3 // LED2 - Output

// Port D
#define BUTTON		3 // INT3 - Input: Button
#define SFD			4 // ICP1 - Input:  SFD from CC2420
#define FIFO		5 // INT1 - Input:  FIFO from CC2420
#define CCA			6 // PD.6 - Input:  CCA from CC2420

// Port E
#define UART0_RXD	0 // RXD0 - Input:  UART1 RXD
#define UART0_TXD	1 // TXD0 - Output: UART1 TXD
#define LED1		2 // LED1 - Output
#define LED2		3 // LED2 - Output
#define FIFOP		4 // INT4 - Input:  FIFOP from CC2420

// Port F


#endif	// ~PLATFORM_H

