//===================================================================
//
// led.h	(@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef LED_H
#define LED_H
#include "kconf.h"
#ifdef LED_M

#include "common.h"

#define NOS_LED_INIT() \
	do { \
		_BIT_SET(DDRE, LED1); \
		_BIT_SET(DDRE, LED2); \
		_BIT_SET(DDRA, LED3); \
		_BIT_SET(DDRC, LED4); \
		_BIT_CLR(PORTE, LED1); \
		_BIT_CLR(PORTE, LED2); \
		_BIT_CLR(PORTA, LED3); \
		_BIT_CLR(PORTC, LED4); \
	} while(0)
	
	
#define NOS_LED_ON(n) \
	do { \
		if ( n == 1 ) \
			_BIT_SET(PORTE, LED1); \
		else if ( n == 2 ) \
			_BIT_SET(PORTE, LED2); \
		else if ( n == 3 ) \
			_BIT_SET(PORTA, LED3); \
		else if ( n == 4 ) \
			_BIT_SET(PORTC, LED4); \
		else { \
			_BIT_SET(PORTE, LED1); \
			_BIT_SET(PORTE, LED2); \
			_BIT_SET(PORTA, LED3); \
			_BIT_SET(PORTC, LED4); \
		} \
	} while(0)

#define NOS_LED_OFF(n) \
	do { \
		if ( n == 1 ) \
			_BIT_CLR(PORTE, LED1); \
		else if ( n == 2 ) \
			_BIT_CLR(PORTE, LED2); \
		else if ( n == 3 ) \
			_BIT_CLR(PORTA, LED3); \
		else if ( n == 4 ) \
			_BIT_CLR(PORTC, LED4); \
		else { \
			_BIT_CLR(PORTE, LED1); \
			_BIT_CLR(PORTE, LED2); \
			_BIT_CLR(PORTA, LED3); \
			_BIT_CLR(PORTC, LED4); \
		} \
	} while(0)
	
#define NOS_LED_TOGGLE(n) \
	do { \
		if ( n == 1 ) \
			PORTE = PINE^(1 << LED1); \
		else if ( n == 2 ) \
			PORTE = PINE^(1 << LED2); \
		else if ( n == 3 ) \
			PORTA = PINA^(1 << LED3); \
		else if ( n == 4 ) \
			PORTC = PINC^(1 << LED4); \
		else { \
			PORTE = PINE^(1 << LED1); \
			PORTE = PINE^(1 << LED2); \
			PORTA = PINA^(1 << LED3); \
			PORTC = PINC^(1 << LED4); \
		} \
	} while(0)

#endif // LED_M
#endif // ~LED_H

