//===================================================================
//
// button.h (@ybpark)
//
//===================================================================
// Copyright 2004-2010
//===================================================================
#ifndef BUTTON_H
#define BUTTON_H
#include "kconf.h"
#ifdef BUTTON_M

#include "common.h"

// BUTTON interrupt
#define ENABLE_BUTTON_INTR()         do { ENABLE_INT3_vect(); } while (0)
#define DISABLE_BUTTON_INTR()        do { DISABLE_INT3_vect(); } while (0)
#define CLEAR_BUTTON_INTR()          do { CLEAR_INT3_vect(); } while (0)
#define IS_SET_BUTTON_INTRFLAG()			IS_SET_INT3_vect_FLAG()

// Pin status
#define BUTTON_IS_SET()	_IS_SET(PIND,BUTTON)

// Functions and Variables
void nos_button_init(void);
void nos_set_button_cb(void (*func)(void));

#endif // BUTTON_M
#endif // ~BUTTON_H
