//===================================================================
//
// button.c (@ybpark)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "button.h"

#ifdef BUTTON_M
#include <avr/io.h>
#include <avr/interrupt.h>
#include "platform.h"
#include "critical_section.h"

static void (*button_callback_func)(void);

void nos_button_init()
{
	ENABLE_BUTTON_INTR();
	// Initialize the FIFOP External interrupt
	EICRA |= (1 << ISC31) | (1 << ISC30);	// Interrupt will be requested in rising edge of INT0
	button_callback_func = NULL;
}

void nos_set_button_cb(void (*func)(void))
{
	button_callback_func = func;
}

ISR(INT3_vect)
{
	NOS_ENTER_ISR();
	
	if ( button_callback_func )
	{
		button_callback_func();
	}
	CLEAR_BUTTON_INTR();
	NOS_EXIT_ISR();
}

#endif //--- BUTTON_M ---//