//===================================================================
//
// sensor_us.h (@sheart, @haekim, @jun361)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SENSOR_US_H
#define SENSOR_US_H
#include "kconf.h"
#ifdef SENSOR_US_M 

#include "common.h"
#include "intr.h"
#include "platform.h"

#define CLEAR_US_INTR()		do { CLEAR_INT7_vect(); } while(0)
#define ENABLE_US_INTR()	do { CLEAR_US_INTR(); ENABLE_INT7_vect(); } while(0)
#define DISABLE_US_INTR()	do { DISABLE_INT7_vect(); } while(0)
#define NOS_US_POWER_ON()		do { CLEAR_US_INTR(); ENABLE_US_INTR(); _BIT_SET(PORTA, US_SENSOR_POWER_SW); } while(0)    // PA0
#define NOS_US_POWER_OFF()		do { _BIT_CLR(PORTA, US_SENSOR_POWER_SW); DISABLE_US_INTR();} while(0)
#define NOS_US_TX_ON()			do { _BIT_SET(PORTF, US_SENSOR_TX_SW); } while(0)    // PF5
#define NOS_US_TX_OFF()			do { _BIT_CLR(PORTF, US_SENSOR_TX_SW); } while(0)

void nos_us_init(void);
void nos_us_callback(void (*func)(void));
void nos_us_trigger(void);
UINT16 nos_us_get_data(void);
	
#endif // SENSOR_US_M
#endif // ~SENSOR_US_H
