//===================================================================
//
// sensor_pir.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SENSOR_PIR_H
#define SENSOR_PIR_H
#include "kconf.h"
#ifdef SENSOR_PIR_M 

#include "common.h"
#include "intr.h"
#include "platform.h"

#define ENABLE_PIR_INTR()	do { ENABLE_INT7_vect(); } while(0)
#define DISABLE_PIR_INTR()	do { DISABLE_INT7_vect(); } while(0)
#define CLEAR_PIR_INTR()		do { CLEAR_INT7_vect(); } while(0)
#define NOS_PIR_POWER_ON()		do { ENABLE_PIR_INTR(); CLEAR_PIR_INTR(); _BIT_CLR(PORTC, PIR_SENSOR_POWER_SW); } while(0)   // PC0
#define NOS_PIR_POWER_OFF()	do { _BIT_SET(PORTC, PIR_SENSOR_POWER_SW); DISABLE_PIR_INTR(); } while(0)   // PC0

void nos_pir_init(void);
void nos_pir_callback(void (*func)(void));

#endif // SENSOR_PIR_M
#endif // ~SENSOR_PIR_H
