//===================================================================
//
// rf.h (@jun361, @haekim)
//		for Nano-24 (ATmega128L, CC2420)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef RF_H
#define RF_H
#include "kconf.h"
#ifdef RF_M

#include "common.h"	// atmega128 + etri_ssn platform

#define RF_RESET_SET()          do { _BIT_CLR(PORTB, RESET_N); } while (0)
#define RF_RESET_CLR()        do { _BIT_SET(PORTB, RESET_N); } while (0)                                                       
#define RF_VREG_SET()           do { _BIT_SET(PORTB, VREG_EN); } while (0)
#define RF_VREG_CLR()         do { _BIT_CLR(PORTB, VREG_EN); } while (0)
#define RF_PORT_INIT() \
do { \
        DDRB  |= (1 << RESET_N) | (1 << VREG_EN) | (1 << MOSI) | (1 << SCK) | (1 << CSN); \
        SPI_DISABLE(); \
} while (0)

// SFD interrupt
//#define ENABLE_SFD_CAPTURE_INTR()    do { ENABLE_TIMER1_CAPT_vect(); } while(0)
//#define DISABLE_SFD_CAPTURE_INTR()   do { DISABLE_TIMER1_CAPT_vect(); } while (0)
//#define CLEAR_SFD_CAPTURE_INTR()     do { CLEAR_TIMER1_CAPT_vect(); } while (0)

// FIFOP interrupt
#define ENABLE_FIFOP_INTR()         do { ENABLE_INT0_vect(); } while (0)
#define DISABLE_FIFOP_INTR()        do { DISABLE_INT0_vect(); } while (0)
#define CLEAR_FIFOP_INTR()          do { CLEAR_INT0_vect(); } while (0)
#define IS_SET_FIFOP_INTRFLAG()			IS_SET_INT0_vect_FLAG()

// Pin status
#define RF_RESET_IS_SET()	_IS_SET(PINB, RESET_N)
#define RF_VREG_IS_SET()	_IS_SET(PINB, VREG_EN)
#define RF_FIFOP_IS_SET()	_IS_SET(PIND,FIFOP)
#define RF_FIFO_IS_SET()		_IS_SET(PIND, FIFO)
#define RF_SFD_IS_SET()		_IS_SET(PIND,SFD)
#define RF_CCA_IS_SET()		_IS_SET(PIND, CCA)
#define RF_RXFIFO_OVERFLOW()	((RF_FIFOP_IS_SET()) && (!(RF_FIFO_IS_SET())))

// Functions and Variables
void nos_rf_init(void);
void nos_set_rf_cb(void (*func)(void));

#endif // RF_M
#endif // ~RF_H
