//===================================================================
//
// rf.c (@jun361, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "rf.h"

#ifdef RF_M
#include <signal.h>
#include "platform.h"
#include "spi.h"
#include "arch.h"
#include "critical_section.h"
#include "cc2420.h"


static void (*callback_func)(void);

void nos_rf_init()
{
        RF_PORT_INIT();

        // Enables SPI
        SPI_INIT();

        // Make sure that the voltage regulator is on, and that the reset pin is inactive
        RF_VREG_SET();
        nos_delay_ms(2);
        RF_RESET_SET();
        nos_delay_us(1);
        RF_RESET_CLR();
        nos_delay_us(5);

        cc2420_init();

        // Initialize the FIFOP External interrupt
	// Interrupt will be requested at the rising edge (low-to-high transition)
	_BIT_CLR(P1IES, FIFOP);
        callback_func = NULL;
}

void nos_set_rf_cb(void (*func)(void))
{
        callback_func = func;
}

wakeup interrupt (PORT1_VECTOR) fifo_rx(void)
{
        NOS_ENTER_ISR();
        if ( callback_func )
        {
                callback_func();
        }
		CLEAR_FIFOP_INTR();
        NOS_EXIT_ISR();
}
#endif
