//===================================================================
//
// platform.h   (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#define SPI_PORT0			1	// Use port0. 
//#define SPI_PORT1			1	// Use port1. 
#define SPI_ENABLE()		do { _BIT_CLR(P4OUT, CSN); } while (0)
#define SPI_DISABLE()		do { _BIT_SET(P4OUT, CSN); } while (0)
#define SIMO                    SIMO0 // P3.1 - Output: SIMO (Slave Input Master Output)
#define SOMI                    SOMI0 // P3.2 - Input: SOMI (Slave Output Master Input)
#define SCK                     UCLK0 // P3.3 - Output: SCK (UCLK0)

#ifdef UART_M
#include "uart.h"
#define STDIN   1
#define STDOUT  1
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef SENSOR_LIGHT_M
#include "sensor_light.h"
#endif
#ifdef SENSOR_MIC_M
#include "sensor_mic.h"
#endif
#ifdef SENSOR_TEMP_M
#include "sensor_temp.h"
#endif
#ifdef SENSOR_HUM_M
#include "sensor_hum.h"
#endif

void nos_platform_init(void);

/*********************** PORT Definition ******************************/
// Port 1
#define FIFOP                   0 // P1.0 
#define FIFO                    3 // P1.3 - FIFO Access 
#define CCA                     4 // P1.4 - Input:  CCA from CC2420
#define SCL   			7 // P1.7 - SCL: Temp, Humidity Sensor Power Switch
//#define TEMP_HUM_SENSOR_POWER_SW    7 // P1.7 - Temp, Humidity Sensor

// Port 2
#define SDA         		0 // P2.0 - SDA
#define LIGHT_SENSOR_POWER_SW	1 // P2.1 - LIGHT Sensor

// Port 3

// Port 4
#define SFD                     1 // P4.1 - Input:  SFD from CC2420
#define CSN                     2 // P4.2 - Output: SPI Chip Select (CS_N)
#define MIC_SENSOR_POWER_SW     3 // P4.3 - Input: MIC Sensor
#define VREG_EN                 5 // P4.5 - CC2420 voltage regulator enable
#define RESET_N                 6 // P4.6 - CC2420 reset  


// Port 5
#define GLED                    4 // P5.4 - Output : LED1
#define RLED                    5 // P5.5 - Output : LED2
#define BLED                    6 // P5.6 - Output : LED3

// Port 6
#define ADC_MIC_CHANNEL		2 // P6.2 - MIC channel
#define ADC_LIGHT_CHANNEL	4 // P6.4 - light channel
#endif	// PLATFORM_H
