//===================================================================
//
// platform.h	(@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"
#include <avr/io.h>

#define SPI_ENABLE()		do { _BIT_CLR(PORTB, CSN); } while (0)
#define SPI_DISABLE()	do { _BIT_SET(PORTB, CSN); } while (0)

#ifdef UART_M
#include "uart.h"
#define STDIN	1
#define STDOUT	1
#endif

#ifdef ADC_M
#include "adc.h" 
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef BAT_POWER_M
#include "bat_power.h"
#endif
#ifdef ACTUATOR_M
#include "actuator.h"
#endif
#ifdef SENSOR_GAS_M
#include "sensor_gas.h"
#endif
#ifdef SENSOR_LIGHT_M
#include "sensor_light.h"
#endif
#ifdef SENSOR_TEMP_M
#include "sensor_temp.h"
#endif
#ifdef SENSOR_PIR_M
#include "sensor_pir.h"
#endif
#ifdef SENSOR_US_M
#include "sensor_us.h"
#endif
#ifdef SENSOR_HUM_M
#include "sensor_hum.h"
#endif

void nos_platform_init(void);

/*********************** PORT Definition ******************************/
// Port A
#define US_SENSOR_POWER_SW		0 // PA.0 - US Sensor Power Switch
#define TEMP_SENSOR_POWER_SW  	0 // PA.0 - Temp Sensor Power Switch
#define LIGHT_SENSOR_POWER_SW	1 // PA.1 - Light Sensor Power Switch
#define HUM_SENSOR_POWER_SW		2 // PA.2 - Humidity Sensor Power Switch

// Port B
#define CSN			0 // PB.0 - Output: SPI Chip Select (CS_N)
#define SCK			1 // PB.1 - Output: SPI Serial Clock (SCLK)
#define MOSI			2 // MOSI - Output: SPI Master out - slave in (MOSI)
#define MISO			3 // MISO - Input:  SPI Master in - slave out (MISO)
#define RESET_N		4 // PB.4 - CC2420 reset  
#define VREG_EN		5 // PB.5 - CC2420 voltage regulator enable
#define ACTUATOR2	6 // PB.6 - Output: Actuator 2
#define ACTUATOR3	7 // PB.7 - Output: Actuator 3

// Port C
#define PIR_SENSOR_POWER_SW		0 // PC.0 - Same for GAS, PIR Sensor Power Switch
#define GAS_SENSOR_POWER_SW		0 // PC.0 - Gas Sensor Power Switch
#define BAT_SW				1 // PC.1 - Battery power monitoring 

// Port D
#define FIFOP		0 // INT0 - Input:  FIFOP from CC2420
#define FIFO			1 // INT1 - Input:  FIFO from CC2420
#define UART1_RXD	2 // RXD1 - Input:  UART1 RXD
#define UART1_TXD	3 // TXD1 - Output: UART1 TXD
#define SFD			4 // ICP1 - Input:  SFD from CC2420
#define ACTUATOR0	5 // PD.5 - Output: Actuator 0
#define CCA			6 // PD.6 - Input:  CCA from CC2420
#define RLED			7 // PD.7 - Output : Red LED
#define HUM_SENSOR_CLK		7 // T2 - Input : humidiy Clock Source

// Port E
#define GLED			0 // PE.0 - Output : Green LED
#define YLED			1 // PE.1 - Output : Yellow LED
//#define AC_plus		2 // PE.2 -
//#define AC_minus	3 // PE.3 -
//#define FLASH_CLK	4 // PE.4 -
//#define FLASH_CSN	5 // PE.5 -
#define US_SENSOR_INTR		7 // INT7 - Falling Edge Interrupt
#define PIR_SENSOR_INTR		7 // INT7 - Falling Edge Interrupt

// Port F
#define ADC_TEMP_CHANNEL	0 //ADC0 - adc channel 0
#define ADC_LIGHT_CHANNEL	1 //ADC1 - adc channel 1
#define ADC_GAS_CHANNEL		2 //ADC2 - adc channel 2
#define US_SENSOR_TX_SW		5 // PF.5 - Output
#define ADC_BAT_CHANNEL		6 //ADC6 - adc channel 6
#define ACTUATOR1			7 // PF.7 - Output: Actuator 1



#endif	// ~PLATFORM_H

