//===================================================================
//
// teno.h (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#ifndef TENO_H
#define TENO_H
#include "kconf.h"
#ifdef TENO_M

#include "common.h"
#include "mac.h"

#define TENO_MAX_TREE_DEPTH	(10)
#define TENO_GENERAL_SINK_ID	(0xFFFF)
#define TENO_BROADCAST_ID		(0xFFFF)
#ifdef MONITOR
#define TENO_MONITOR_PORT	(0xFF)
#endif

// Packet size
#define TENO_JOIN_PACKET_SIZE 	(sizeof(TENO_JOIN_PACKET))
#define TENO_REPLY_PACKET_SIZE 	(sizeof(TENO_REPLY_PACKET))
#define TENO_RELEASE_PACKET_SIZE 	(sizeof(TENO_RELEASE_PACKET))
#define TENO_DATA_PACKET_HEADER_SIZE 	(sizeof(TENO_DATA_PACKET)-sizeof(void*))
#define TENO_MAX_PACKET_PAYLOAD_SIZE 	(NOS_MAC_MAX_PAYLOAD_SIZE - TENO_DATA_PACKET_HEADER_SIZE)	//116(NanoMAC)-14 = 102

// Message type (01~0F : RENO, 11~1F : TENO)
#define TENO_JOIN		(0x11)
#define TENO_REPLY	(0x12)
#define TENO_RELEASE	(0x13)
#define TENO_UPDATA	(0x14)
#define TENO_DOWNDATA	(0x15)

// State
#define TENO_ALONE_STATE	20
#define	TENO_JOIN_STATE	21
#define	TENO_SINK_STATE	22

// Network layer packet format.  [UINT16] should be aligned at even address
typedef struct _teno_join_packet
{
	UINT8 msg_type;
	UINT8 depth;
} TENO_JOIN_PACKET;

typedef struct _teno_reply_packet
{
	UINT8 msg_type;
	UINT8 depth;
} TENO_REPLY_PACKET;

typedef struct _teno_release_packet
{
	UINT8 msg_type;
} TENO_RELEASE_PACKET;

typedef struct _teno_data_packet
{
	UINT8 msg_type;
	UINT8 msg_hop_limit;
	UINT8 msg_hop_count;
	UINT8 depth;	// depth of MAC layer source node (current sensor node's depth)
	UINT16 seq;
	UINT16 dest_id;	// should be located at even
	UINT16 src_id;
	UINT16 parent_id;
	UINT8 port;
	UINT8 payload_size;
	void  *payload_ptr; // Packet payload
} TENO_DATA_PACKET;

// Each node has one NIB (network information base)
typedef struct _teno_network_informaion_base
{
	UINT16	my_id; 	 // my ID.
	UINT8	my_depth;
	UINT8	state;
	UINT16	tx_seq;
	UINT16	parent_id;	// parent
	UINT16	parent_candidate;
	BOOL	candidate;
} TENO_NIB;
extern TENO_NIB teno_nib;

#define TENO_GET_PARENT_ID	(teno_nib.parent_id)
#define TENO_GET_MY_DEPTH		(teno_nib.my_depth)


void teno_init(UINT8 channel, UINT16 pan_id, UINT16 node_id);
void teno_set_rx_cb(void (*func)(void));
void teno_role_as_sink(void);
void teno_role_as_node(void);
BOOL teno_send_to_sink(UINT8 port, UINT8 data_length, void* data);
BOOL teno_send_to_node(UINT16 dest_id, UINT8 port, UINT8 data_length, void* data);
void teno_recv_from_nwk(UINT16* src_id, UINT8* port, UINT8* data_length, void* data, UINT16* parent_id, UINT16* dest_id);
#ifdef DEMO_MAC_M
void teno_set_rx_range(UINT16 min_permit_id, UINT16 max_permit_id);
#endif

void teno_cb_from_mac(void);
void teno_start_alone_state(void);
void teno_join_timer(void);
void teno_send_join_to_mac(void);
BOOL teno_send_reply_to_mac(UINT16 dest_id);
BOOL teno_send_release_to_mac(UINT16 dest_id);
BOOL teno_send_data_to_mac(TENO_DATA_PACKET* tx_packet_ptr, UINT16 dest_id);
BOOL teno_broadcast_data_downward(TENO_DATA_PACKET* tx_packet_ptr);
BOOL teno_send_data_upward(TENO_DATA_PACKET* tx_packet_ptr);
BOOL teno_del_curr_parent(void);
void teno_recv_from_mac(void);
void teno_recv_updata_from_mac(void);
void teno_recv_downdata_from_mac(void);
void teno_store_data(TENO_DATA_PACKET* rx_packet_ptr);
BOOL teno_updata_handler(TENO_DATA_PACKET* rx_packet_ptr, UINT16 prev_hop_id, INT8 rssi);


#endif // TENO_M
#endif // ~TENO_H
//=========================== End of (teno.h) =========================

