//===================================================================
//
// routing.h (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#ifndef ROUTING_H
#define ROUTING_H
#include "kconf.h"
#ifdef ROUTING_M

//#include "common.h"
#include "mac.h"

#ifdef RENO_M
#include "reno.h"
#define NOS_NWK_MAX_PAYLOAD_SIZE	RENO_MAX_PACKET_PAYLOAD_SIZE	//109
#define nos_nwk_init(channel, panaddr, node_id, min, max)	reno_init(channel, panaddr, node_id, min, max)	//void reno_init(UINT8 channel, UINT16 pan_id, UINT8 node_id, UINT8 min_permit_id, UINT8 max_permit_id)
#define nos_nwk_set_rx_cb(func)			reno_set_rx_cb(func)
#define nos_nwk_rx(src_id, len, data)	reno_recv_from_nwk(src_id, len, data)	//BOOL reno_recv_from_nwk(UINT8* src_id, UINT8* data_length, void* data)
#define nos_nwk_tx(dest_id, len, data)	reno_send_to_nwk(dest_id, len, data)		//void reno_send_to_nwk(UINT8 dest_id, UINT8 data_length, void *data)
#endif

#ifdef TENO_M
#include "teno.h"
#define NOS_NWK_MAX_PAYLOAD_SIZE	TENO_MAX_PACKET_PAYLOAD_SIZE	//102
#define nos_nwk_init(channel, panaddr, node_id)		teno_init(channel, panaddr, node_id)	// void teno_init(UINT8 channel, UINT16 pan_id, UINT16 node_id);
#define nos_nwk_set_rx_cb(func)						teno_set_rx_cb(func)	// void teno_set_rx_cb(void (*func)(void));
#define nos_nwk_set_to_sink()						teno_role_as_sink() // void teno_role_as_sink(void);
#define nos_nwk_set_to_node()						teno_role_as_node() //void teno_role_as_node(void);
#define nos_nwk_rx(src_id, port, len, data, parent_id, dest_id)			teno_recv_from_nwk(src_id, port, len, data, parent_id, dest_id)	//void teno_recv_from_nwk(UINT16* src_id, UINT8* port, UINT8* data_length, void* data, UINT16* parent_id, UINT16* dest_id);
#define nos_nwk_tx_to_sink(port, len, data)			teno_send_to_sink(port, len, data)	//BOOL teno_send_to_sink(UINT8 port, UINT8 data_length, void* data);
#define nos_nwk_tx(dest_id, port, len, data)		teno_send_to_node(dest_id, port, len, data)	//BOOL teno_send_to_node(UINT16 dest_id, UINT8 port, UINT8 data_length, void* data);
#ifdef DEMO_MAC_M
#define nos_nwk_set_rx_range(min_permit_id, max_permit_id)	teno_set_rx_range(min_permit_id, max_permit_id) //void teno_set_rx_range(UINT16 min_permit_id, UINT16 max_permit_id);
#endif
#endif

#endif //--- ROUTING_M ---//
#endif //--- ~ROUTING_H ---//
//=========================== End of (routing.h) ============================

