//===================================================================
//
// reno_interlayer.c (@haekim)
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "reno.h"
#ifdef RENO_M
#include <string.h>
#include "mac.h"
#include "critical_section.h"
#include "heap.h"

extern BOOL nos_taskq_reg(void (*func)(void));
extern void reno_handler(RENO_SIB *sib_ptr);

//=======================================================================================
//		inter-layer operation functions (Application <-> Network)
//=======================================================================================		

// [USER API] receives data form the RENO_QUEUE.
// bug : if sizeof (data) < data_length --> return???
BOOL reno_recv_from_nwk(UINT8* src_id, UINT8* data_length, void* data)
{
	NOS_ENTER_CRITICAL_SECTION();
	// if queue is not empty
	//if (RENO_QUEUE.front != RENO_QUEUE.rear)
	if (RENO_QUEUE.nitem != 0)
	{
		*src_id = RENO_QUEUE.item[RENO_QUEUE.front].src_id;
		*data_length = RENO_QUEUE.item[RENO_QUEUE.front].data_length;
		memcpy(data, (void*)(RENO_QUEUE.item[RENO_QUEUE.front].data), *data_length);
		RENO_QUEUE.front = (RENO_QUEUE.front+1)%RENO_QUEUE_LENGTH;
		--RENO_QUEUE.nitem;
		NOS_EXIT_CRITICAL_SECTION();
		return TRUE;
	}
	else
	{
		NOS_EXIT_CRITICAL_SECTION();
		return FALSE; // queue is empty.
	}
}


// [USER API] sends data.
void reno_send_to_nwk(UINT8 dest_id, UINT8 data_length, void* data)
{
	RENO_SIB send_sib;
	send_sib.prev_hop_id 		= RENO_NIB.id;
	send_sib.packet.msg_type 	= RENO_DATA;
	send_sib.packet.msg_hop_limit 	= NET_DIAMETER;
	send_sib.packet.msg_hop_count 	= 0;
	send_sib.packet.reserved 	= 0;
	send_sib.packet.dest_id		= dest_id;
	send_sib.packet.src_id 		= RENO_NIB.id;	
	send_sib.packet.payload_size 	= data_length;
	send_sib.packet.payload_ptr 	= nos_malloc((UINT16)send_sib.packet.payload_size);	//fragmentation?? nos_malloc(NMAC_MAX_PAYLOAD_SIZE)??
	memcpy(send_sib.packet.payload_ptr, data, data_length);
	reno_handler(&send_sib);
	nos_free(send_sib.packet.payload_ptr);
}

//=======================================================================================
//		inter-layer operation functions (Network <-> MAC)
//=======================================================================================		

// This is called from IDLE thread only.
void reno_recv_from_mac(void)
{
	NMAC_RX_INFO mac_rx_info;
	RENO_SIB recv_sib;
	mac_rx_info.payload_ptr = nos_malloc(NMAC_MAX_PAYLOAD_SIZE);
	while ( nmac_rx( &mac_rx_info) )
	{
		recv_sib.prev_hop_id 		= (UINT8)mac_rx_info.src_addr;
		//recv_sib.next_hop_id is handled in [ void reno_handler(RENO_SIB*) ]	

		recv_sib.packet.msg_type 	= ((UINT8*)mac_rx_info.payload_ptr)[0];
		recv_sib.packet.msg_hop_limit 	= ((UINT8*)mac_rx_info.payload_ptr)[1];
		recv_sib.packet.msg_hop_count 	= ((UINT8*)mac_rx_info.payload_ptr)[2]+1; // ++hop_count !!!
		if (recv_sib.packet.msg_hop_count > recv_sib.packet.msg_hop_limit)
		{
			continue;
		}
		recv_sib.packet.reserved 	= ((UINT8*)mac_rx_info.payload_ptr)[3];
		recv_sib.packet.dest_id 	= ((UINT8*)mac_rx_info.payload_ptr)[4];
		recv_sib.packet.src_id		= ((UINT8*)mac_rx_info.payload_ptr)[5];
		recv_sib.packet.payload_size 	= ((UINT8*)mac_rx_info.payload_ptr)[6];
		recv_sib.packet.payload_ptr 	= (void *) &(((UINT8*)mac_rx_info.payload_ptr)[7]); //== RENO_NIB.recv_data
		reno_handler( &recv_sib );
	}
	nos_free(mac_rx_info.payload_ptr);
}

BOOL reno_send_to_mac(RENO_SIB* sib_ptr, BOOL is_broadcast)
{
	NMAC_TX_INFO mac_tx_info;
	mac_tx_info.routing_header_length 	= RENO_PACKET_HEADER_SIZE;
	mac_tx_info.payload_length 	= RENO_PACKET_HEADER_SIZE + sib_ptr->packet.payload_size;
	mac_tx_info.routing_header_ptr 	= &(sib_ptr->packet);
	mac_tx_info.payload_ptr    	= sib_ptr->packet.payload_ptr;
	if (is_broadcast)
	{
		// To prohibit the ping pong communication is handled in BOOL reno_insert_route_entry ( RENO_SIB* sib_ptr )
		mac_tx_info.dest_addr   = 0xffff;		
		return nmac_tx_noack(&mac_tx_info);			
	}
	else
	{
		mac_tx_info.dest_addr  	= (UINT16) sib_ptr->next_hop_id;
		return nmac_tx(&mac_tx_info);
	}
}

// to handle the RX frame out of interrupt handler
void reno_cb_from_mac(void)
{
	nos_taskq_reg( reno_recv_from_mac );
}

#endif //--- RENO_M ---//

