//===================================================================
//
// reno.h (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#ifndef RENO_H
#define RENO_H
#include "kconf.h"
#ifdef RENO_M

#include "common.h"
#include "mac.h"

// Maximum packet_payload_size 109 = 116 - NET_HEADER(7) for intraPAN bit on (109 for intraPAN bit off)
#define RENO_PACKET_HEADER_SIZE 	(7)    // (sizeof(RENO_PACKET) - sizeof (payload relavant))
#define RENO_MAX_PACKET_PAYLOAD_SIZE 	(NOS_MAC_MAX_PAYLOAD_SIZE - RENO_PACKET_HEADER_SIZE)	//109

#define RENO_QUEUE_LENGTH		(3)
#define MAX_ROUTE_ENTRY 	(100)  // 6byte per entry. must be < 255. The number of entries in routing table that each node maintains
#define NET_DIAMETER 		(30)  // The maximum hop limit of RENO_PACKET messages

// Routing message type
#define RENO_DATA	(11)	//B
#define RENO_RREQ	(12)	//C
#define RENO_RREP	(13)	//D
#define RENO_RERR	(14)	//E

typedef struct _reno_recv_data
{
	UINT8 src_id;
	UINT8 data_length;
	UINT8 data[RENO_MAX_PACKET_PAYLOAD_SIZE];
}RENO_RECV_DATA;

// Network layer packet format
typedef struct _reno_packet
{
	// packet header (7 bytes)
	// TO DO : These will be changed into (UINT16 packet_control_field)
	UINT8 msg_type;      	// 4 types
	UINT8 msg_hop_limit; 	// maximum 32 hops.
	UINT8 msg_hop_count; 	// maximum 32 hops.
	UINT8 reserved; 	// reserved.
	UINT8 dest_id;
	UINT8 src_id;
	UINT8 payload_size;
	void  *payload_ptr; // Packet payload
} RENO_PACKET;


// Network SIB (Session Infomation Base) 
// This is just for one-hop communication.
typedef struct _reno_session_information_base
{
	UINT8 prev_hop_id;
	UINT8 next_hop_id;  // to deliver next node information from routing table to MAC layer destination address.
	RENO_PACKET packet;
} RENO_SIB;

// Routing table entry
typedef struct _reno_route_entry
{
	UINT8  dest_id;
	UINT16 dest_seq_num; // to maintain latest routing information.
	UINT8  next_hop_id;  // next node ID for sending a packet to the destination node.
	BOOL   is_valid;     // check if valid or not
	UINT8 link_fail_count; 	//for RERR
} RENO_ROUTE_ENTRY;

struct reno_queue
{
	UINT8 front, rear, nitem;
	RENO_RECV_DATA item[RENO_QUEUE_LENGTH];
} RENO_QUEUE;

// Each node has one NIB (network information base)
struct reno_network_informaion_base
{
	UINT8  id; 	 // my node ID.
	UINT16 seq_num;  // my routing information message sequence

	// Keeps saving routing table.
	RENO_ROUTE_ENTRY route_table[MAX_ROUTE_ENTRY];
	UINT8 route_table_index; // The index of the next position of RENO_ROUTE_ENTRY inserted lately in the route_table array
	//UINT8 recv_data[RENO_MAX_PACKET_PAYLOAD_SIZE]; // stores a received packet coming from MAC layer (MAC layer payload). Queue is better???
	//UINT8 recv_data_length; // should be less than RENO_MAX_PACKET_PAYLOAD_SIZE
	//UINT8 min_permit_id; // The minimum node id permitted to receive data from.
	//UINT8 max_permit_id; // The maximum node id permitted to receive data from.
} RENO_NIB;



//------------<routing.c>-------------
void reno_init(UINT8 channel, UINT16 pan_id, UINT8 node_id, UINT8 min_permit_id, UINT8 max_permit_id);
void reno_set_rx_cb(void (*func)(void));

#ifdef MONITOR
void rreq_for_monitor (RENO_SIB* sib_ptr);
void call_monitor (RENO_SIB* sib_ptr, UINT8 msgType);
void set_mon_func(void (*func)(RENO_SIB* sib_ptr, UINT8 msgType));//rreq:1, no rreq:2
#endif

#ifdef UART_M
void print_route_table(void);
void print_nib(void);
void print_sib(RENO_SIB *sib_ptr);
void print_payload(INT8 payload_unit, UINT8 payload_size, void *payload);
#endif

//-------------<routing_interlayer.c>-------------
BOOL reno_recv_from_nwk(UINT8* src_id, UINT8* data_length, void* data);
void reno_send_to_nwk(UINT8 dest_id, UINT8 data_length, void *data);
void reno_recv_from_mac(void);
BOOL reno_send_to_mac(RENO_SIB *sib_ptr, BOOL is_broadcast);
void reno_cb_from_mac(void);

#endif // RENO_M
#endif // ~RENO_H
//=========================== End of (reno.h) =========================

