//===================================================================
//
// mac.h (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#ifndef MAC_H
#define MAC_H
#include "kconf.h"
#ifdef MAC_M

#ifdef NANO_MAC_M
#include "nano_mac.h"
#define NOS_MAC_MAX_PAYLOAD_SIZE	NMAC_MAX_PAYLOAD_SIZE
#define nos_mac_rx_on()		nmac_rx_on()
#define nos_mac_rx_off()	nmac_rx_off()
#define nos_mac_init(channel, panaddr, myaddr)	nmac_init(channel, panaddr, myaddr)
#define nos_mac_set_tx_power(level)				nmac_set_tx_power(level);
#define nos_mac_set_rx_cb(func)					nmac_set_rx_cb(func)
#define nos_mac_tx_noack(frame)					nmac_tx_noack(frame)
#define nos_mac_tx(frame)	nmac_tx(frame)
#define nos_mac_rx(frame)	nmac_rx(frame)
#ifdef DEMO_MAC_M
#define nos_mac_set_rx_range(min, max)	nmac_set_rx_range(min, max)
#endif
#endif


#ifdef IEEE_802_15_4_MAC
#include "mac_headers.h"
#define nos_mac_rx_on()		zbmac_rx_on()
#define nos_mac_rx_off()	zbmac_rx_off()
#define nos_mac_init(channel, panaddr, myaddr)	zbmac_init(channel, panaddr, myaddr)
#define nos_mac_set_rx_cb(func)	zbmac_set_rx_cb(func)
#define nos_mac_tx_noack(frame)	zbmac_tx_noack(frame)
#define nos_mac_tx(frame)	zbmac_tx(frame)
#define nos_mac_rx(frame)	zbmac_rx(frame)
#ifdef DEMO_MAC_M
#define nos_mac_set_rx_range(min, max)	zbmac_set_rx_range(min, max)
#endif
#endif

#endif // MAC_M
#endif // ~MAC_H
//=========================== End of (mac.h) ============================

