//===================================================================
//
// thread_wakeup.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "thread.h"


#ifdef KERNEL_M
#include "arch.h"
#include "critical_section.h"
#include "sched.h"

extern THREADQ _rdy_q[PRIORITY_LEVEL_COUNT];
extern UINT8 	_ready_priority_bit;	// priority bit setting for threads, which is set for the priority of the thread when the thread becomes in ready state.

UINT8 nos_thread_wakeup(UINT8 tid)
{
	UINT8 i;
        UINT16 ticks_diff;

NOS_ENTER_CRITICAL_SECTION();
	if (_rtid == tid) // self-resume; this cannot happen
	{
		NOS_EXIT_CRITICAL_SECTION();
		return THREAD_WAKEUP_ERROR;
	}
	else
	{
		if (NOS_THREAD_IS_NOT_SLEEP(tid))
		{
			NOS_EXIT_CRITICAL_SECTION();
			return THREAD_WAKEUP_ERROR;
		}	
		else // sleeping (this thread is in sleeping state)
		{
			// wakeup this thread
			_BIT_CLR(_sleep_tid_bit, tid);
			i = tcb[tid]->priority;
			tcb[tid]->state = READY_STATE; // make it ready
			tcb[tid]->sleep_tick = 0;
			THREADQ_ENQ(_rdy_q[i], tid);
			_BIT_SET(_ready_priority_bit, i);

			if (_sleep_tid_bit)
			{
                         	ticks_diff = _init_ticks_left - _ticks_left;
                              	_ticks_left = 65535;

                                // for all sleeping threads, find a minimum _init_ticks_left after substracting ticks_diff
                                for (i=1; i<MAX_NUM_TOTAL_THREAD; i++)
                                {
                                        if (NOS_THREAD_IS_SLEEP(i))
                                        {
                                                tcb[i]->sleep_tick -= ticks_diff;
                                                if (_ticks_left > tcb[i]->sleep_tick)
                                                        _ticks_left = tcb[i]->sleep_tick;
                                        }
                                }
                                _init_ticks_left = _ticks_left;
			}

			NOS_EXIT_CRITICAL_SECTION();
			return THREAD_NO_ERROR;
		}
	}
}
#endif
